/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.pagesubscription.generator;

import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.Map;
import org.ametys.cms.content.ContentHelper;
import org.ametys.cms.contenttype.ContentTypesHelper;
import org.ametys.cms.repository.Content;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.util.DateUtils;
import org.ametys.core.util.IgnoreRootHandler;
import org.ametys.plugins.pagesubscription.Subscription;
import org.ametys.plugins.pagesubscription.notification.TagNotificationsHelper;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.source.impl.SitemapSource;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class UserTagNotificationsGenerator
extends ServiceableGenerator {
    protected TagNotificationsHelper _notificationHelper;
    protected AmetysObjectResolver _resolver;
    protected ContentHelper _contentHelper;
    protected SourceResolver _srcResolver;
    protected ContentTypesHelper _contentTypesHelper;
    protected CurrentUserProvider _currentUserProvider;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._notificationHelper = (TagNotificationsHelper)((Object)smanager.lookup(TagNotificationsHelper.ROLE));
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
        this._contentHelper = (ContentHelper)smanager.lookup(ContentHelper.ROLE);
        this._srcResolver = (SourceResolver)smanager.lookup(SourceResolver.ROLE);
        this._contentTypesHelper = (ContentTypesHelper)smanager.lookup(ContentTypesHelper.ROLE);
        this._currentUserProvider = (CurrentUserProvider)smanager.lookup(CurrentUserProvider.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        this.contentHandler.startDocument();
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String subscriptionId = (String)request.get("subscriptionId");
        String viewName = (String)request.get("viewName");
        Subscription subscription = (Subscription)this._resolver.resolveById(subscriptionId);
        subscription.getSubscriptionType().markAsRead(subscription, this._currentUserProvider.getUser());
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"contents");
        for (Content content : this._notificationHelper.getUpdatedContents(subscription).keySet()) {
            this._saxContent(this.contentHandler, content, viewName);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"contents");
        this.contentHandler.endDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _saxContent(ContentHandler handler, Content content, String viewName) throws SAXException, IOException {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("id", content.getId());
        attrs.addCDATAAttribute("name", content.getName());
        attrs.addCDATAAttribute("title", content.getTitle(null));
        attrs.addCDATAAttribute("lastModifiedAt", DateUtils.zonedDateTimeToString((ZonedDateTime)content.getLastModified()));
        XMLUtils.startElement((ContentHandler)handler, (String)"content", (Attributes)attrs);
        String uri = this._contentHelper.getContentHtmlViewUrl(content, viewName, Map.of("checkUserAccess", "true"));
        SitemapSource src = null;
        try {
            src = (SitemapSource)this._srcResolver.resolveURI(uri);
            src.toSAX((ContentHandler)new IgnoreRootHandler(handler));
        }
        finally {
            this._srcResolver.release((Source)src);
        }
        XMLUtils.endElement((ContentHandler)handler, (String)"content");
    }
}

