/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.pagesubscription.generator;

import java.io.IOException;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserManager;
import org.ametys.plugins.pagesubscription.BroadcastChannelHelper;
import org.ametys.plugins.pagesubscription.FrequencyHelper;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class UserTagSubscriptionsGenerator
extends ServiceableGenerator {
    protected CurrentUserProvider _currentUserProvider;
    protected UserManager _userManager;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(this.manager);
        this._currentUserProvider = (CurrentUserProvider)smanager.lookup(CurrentUserProvider.ROLE);
        this._userManager = (UserManager)smanager.lookup(UserManager.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        this.contentHandler.startDocument();
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"subscriptions");
        this._saxBroadcastChannels();
        this._saxFrequencies();
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"subscriptions");
        this.contentHandler.endDocument();
    }

    protected void _saxBroadcastChannels() throws SAXException {
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"broadcastChannels");
        for (BroadcastChannelHelper.BroadcastChannel broadcastChannel : BroadcastChannelHelper.BroadcastChannel.values()) {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("name", broadcastChannel.name());
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"broadcastChannel", (Attributes)attrs);
            BroadcastChannelHelper.getLabel(broadcastChannel).toSAX(this.contentHandler, "label");
            BroadcastChannelHelper.getSmartLabel(broadcastChannel).toSAX(this.contentHandler, "smartLabel");
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"broadcastChannel");
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"broadcastChannels");
    }

    protected void _saxFrequencies() throws SAXException {
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"frequencies");
        for (FrequencyHelper.Frequency frequency : FrequencyHelper.Frequency.values()) {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("name", frequency.name());
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"frequency", (Attributes)attrs);
            FrequencyHelper.getSmartLabel(frequency).toSAX(this.contentHandler, "smartLabel");
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"frequency");
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"frequencies");
    }
}

