/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.pagesubscription.observation;

import jakarta.mail.MessagingException;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.ametys.cms.repository.Content;
import org.ametys.cms.tag.CMSTag;
import org.ametys.cms.transformation.xslt.ResolveURIComponent;
import org.ametys.core.observation.AsyncObserver;
import org.ametys.core.observation.Event;
import org.ametys.core.right.RightManager;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.util.I18nUtils;
import org.ametys.core.util.mail.SendMailHelper;
import org.ametys.plugins.pagesubscription.BroadcastChannelHelper;
import org.ametys.plugins.pagesubscription.FrequencyHelper;
import org.ametys.plugins.pagesubscription.Subscription;
import org.ametys.plugins.pagesubscription.context.TagSubscriptionContext;
import org.ametys.plugins.pagesubscription.mail.TagSubscriptionSummaryMailBodyHelper;
import org.ametys.plugins.pagesubscription.type.SubscriptionTypeExtensionPoint;
import org.ametys.plugins.pagesubscription.type.TagSubscriptionType;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.activities.Activity;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.activities.PageUpdatedActivityType;
import org.ametys.web.renderingcontext.RenderingContext;
import org.ametys.web.renderingcontext.RenderingContextHandler;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.PageDAO;
import org.ametys.web.repository.site.Site;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang3.StringUtils;

public class SendTagNotificationOnCreatedActivityObserver
extends AbstractLogEnabled
implements AsyncObserver,
Serviceable,
Contextualizable {
    protected AmetysObjectResolver _resolver;
    protected I18nUtils _i18nUtils;
    protected UserManager _userManager;
    protected SubscriptionTypeExtensionPoint _subscriptionTypeEP;
    protected TagSubscriptionType _tagSubscriptionType;
    protected RightManager _rightManager;
    protected PageDAO _pageDAO;
    protected RenderingContextHandler _renderingContextHandler;
    protected Context _context;

    public void service(ServiceManager manager) throws ServiceException {
        this._subscriptionTypeEP = (SubscriptionTypeExtensionPoint)((Object)manager.lookup(SubscriptionTypeExtensionPoint.ROLE));
        this._tagSubscriptionType = (TagSubscriptionType)this._subscriptionTypeEP.getExtension("subscription.tag");
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._i18nUtils = (I18nUtils)manager.lookup(I18nUtils.ROLE);
        this._userManager = (UserManager)manager.lookup(UserManager.ROLE);
        this._rightManager = (RightManager)manager.lookup(RightManager.ROLE);
        this._pageDAO = (PageDAO)manager.lookup(PageDAO.ROLE);
        this._renderingContextHandler = (RenderingContextHandler)manager.lookup(RenderingContextHandler.ROLE);
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public boolean supports(Event event) {
        if ("activity.created".equals(event.getId())) {
            Activity activity = (Activity)event.getArguments().get("activity");
            return activity != null && activity.getActivityType() instanceof PageUpdatedActivityType;
        }
        return false;
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void observe(Event event, Map<String, Object> transientVars) throws Exception {
        String activityId = (String)event.getArguments().get("activityId");
        Activity activity = (Activity)this._resolver.resolveById(activityId);
        String pageId = (String)activity.getValue("pageId");
        Page page = (Page)this._resolver.resolveById(pageId);
        Request request = ContextHelper.getRequest((Context)this._context);
        request.setAttribute("site", (Object)page.getSiteName());
        RenderingContext currentContext = this._renderingContextHandler.getRenderingContext();
        try {
            this._renderingContextHandler.setRenderingContext(RenderingContext.FRONT);
            Map<CMSTag, Set<UserIdentity>> subscribersByTag = this._getSubscribersByTag(page, activity);
            for (CMSTag tag : subscribersByTag.keySet()) {
                String subject = this._getMailSubject(page, tag, activity);
                String mailBodyHTML = this._getMailHtmlBody(page, tag, activity);
                List<String> recipients = subscribersByTag.get(tag).stream().map(u -> this._userManager.getUser(u)).filter(Objects::nonNull).map(User::getEmail).filter(StringUtils::isNotBlank).toList();
                try {
                    SendMailHelper.newMail().withRecipients(recipients).withSubject(subject).withHTMLBody(mailBodyHTML).withAsync(true).withInlineCSS(false).sendMail();
                }
                catch (MessagingException | IOException e) {
                    this.getLogger().warn("Could not send a notification e-mail to {}", recipients, (Object)e);
                }
            }
        }
        finally {
            this._renderingContextHandler.setRenderingContext(currentContext);
        }
    }

    protected Map<CMSTag, Set<UserIdentity>> _getSubscribersByTag(Page page, Activity activity) {
        HashMap<CMSTag, Set<UserIdentity>> subscribersByTag = new HashMap<CMSTag, Set<UserIdentity>>();
        UserIdentity author = activity.getAuthor();
        for (String tagName : (String[])activity.getValue("contentTags", (Object)new String[0])) {
            TagSubscriptionContext context = TagSubscriptionContext.newInstance().withTag(tagName);
            List<UserIdentity> allSubscribers = this._tagSubscriptionType.getSubscribers(page.getSite(), FrequencyHelper.Frequency.INSTANT, BroadcastChannelHelper.BroadcastChannel.MAIL, context).stream().filter(u -> !u.equals((Object)author)).filter(u -> this._rightManager.hasReadAccess(u, (Object)page)).toList();
            for (UserIdentity subscriber : allSubscribers) {
                for (Subscription subscription : this._tagSubscriptionType.getUserSubscriptions(page.getSite(), FrequencyHelper.Frequency.INSTANT, BroadcastChannelHelper.BroadcastChannel.MAIL, subscriber, false, context)) {
                    CMSTag tag = this._tagSubscriptionType.getTarget(subscription);
                    Set subscribers = subscribersByTag.getOrDefault(tag, new HashSet());
                    subscribers.add(subscriber);
                    subscribersByTag.put(tag, subscribers);
                }
            }
        }
        return subscribersByTag;
    }

    protected String _getMailSubject(Page page, CMSTag tag, Activity activity) {
        Map<String, I18nizableText> params = Map.of("tag", tag.getTitle(), "site", new I18nizableText(page.getSite().getTitle()));
        I18nizableText i18nSubject = new I18nizableText("plugin.page-subscription", "PLUGINS_PAGE_SUBSCRIPTION_MAIL_TAG_NOTIFICATIONS_MAIL_SUBJECT", params);
        return this._i18nUtils.translate((I18nizable)i18nSubject, page.getSitemapName());
    }

    protected String _getMailHtmlBody(Page page, CMSTag tag, Activity activity) throws IOException {
        Site site = page.getSite();
        String contentId = (String)activity.getValue("contentId");
        Content content = (Content)this._resolver.resolveById(contentId);
        String lang = content.getLanguage();
        TagSubscriptionSummaryMailBodyHelper.MailBodyBuilder bodyBuilder = TagSubscriptionSummaryMailBodyHelper.newHTMLBody().withLanguage(lang).withTitle(this._getMailBodyTitle(tag)).withHint(new I18nizableText("plugin.page-subscription", "PLUGINS_PAGE_SUBSCRIPTION_MAIL_TAG_NOTIFICATIONS_MAIL_MESSAGE_INSTANT")).withContents(Set.of(content)).withLink(site.getUrl(), new I18nizableText("plugin.page-subscription", "PLUGINS_PAGE_SUBSCRIPTION_MAIL_NOTIFICATIONS_MAIL_SITE_LINK"));
        Optional<String> pageTagUrl = this._pageDAO.findPagedIdsByTag(site.getName(), lang, "TAG_SUBSCRIPTIONS_CONFIG").stream().map(id -> ResolveURIComponent.resolve((String)"page", (String)id, (boolean)false, (boolean)true)).findFirst();
        if (pageTagUrl.isPresent()) {
            bodyBuilder.withFooterLink(pageTagUrl.get(), new I18nizableText("plugin.page-subscription", "PLUGINS_PAGE_SUBSCRIPTION_MAIL_TAG_NOTIFICATIONS_MAIL_PREFERENCE_LINK"), "core-ui", "img/mail/icon-letter.png");
        }
        return bodyBuilder.build();
    }

    private I18nizableText _getMailBodyTitle(CMSTag tag) {
        Map<String, I18nizableText> params = Map.of("tag", tag.getTitle());
        return new I18nizableText("plugin.page-subscription", "PLUGINS_PAGE_SUBSCRIPTION_MAIL_TAG_NOTIFICATIONS_MAIL_TITLE", params);
    }
}

