/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.pagesubscription.schedulable.tag;

import java.util.Map;
import java.util.Set;
import org.ametys.core.engine.BackgroundEngineHelper;
import org.ametys.plugins.pagesubscription.BroadcastChannelHelper;
import org.ametys.plugins.pagesubscription.FrequencyHelper;
import org.ametys.plugins.pagesubscription.Subscription;
import org.ametys.plugins.pagesubscription.schedulable.tag.ForcedSubscriptionSchedulerHelper;
import org.ametys.plugins.pagesubscription.type.SubscriptionTypeExtensionPoint;
import org.ametys.plugins.pagesubscription.type.TagSubscriptionType;
import org.ametys.runtime.plugin.Init;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Context;
import org.apache.cocoon.environment.Request;
import org.quartz.SchedulerException;

public class InitSchedulerForForcedSubscription
implements Init,
Serviceable,
Contextualizable,
LogEnabled {
    protected SubscriptionTypeExtensionPoint _subscriptionTypeEP;
    protected TagSubscriptionType _tagSubscriptionType;
    protected SiteManager _siteManager;
    protected ForcedSubscriptionSchedulerHelper _groupTagRunnableHelper;
    protected ServiceManager _manager;
    protected org.apache.avalon.framework.context.Context _context;
    protected Context _cocoonContext;
    protected Logger _logger;

    public void service(ServiceManager manager) throws ServiceException {
        this._manager = manager;
        this._siteManager = (SiteManager)manager.lookup(SiteManager.ROLE);
        this._subscriptionTypeEP = (SubscriptionTypeExtensionPoint)((Object)manager.lookup(SubscriptionTypeExtensionPoint.ROLE));
        this._tagSubscriptionType = (TagSubscriptionType)this._subscriptionTypeEP.getExtension("subscription.tag");
        this._groupTagRunnableHelper = (ForcedSubscriptionSchedulerHelper)((Object)manager.lookup(ForcedSubscriptionSchedulerHelper.ROLE));
    }

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        this._context = context;
        this._cocoonContext = (Context)context.get((Object)"environment-context");
    }

    public void enableLogging(Logger logger) {
        this._logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws Exception {
        Map environment = BackgroundEngineHelper.createAndEnterEngineEnvironment((ServiceManager)this._manager, (Context)this._cocoonContext, (Logger)this._logger);
        try {
            for (Site site : this._siteManager.getSites()) {
                Request request = ContextHelper.getRequest((org.apache.avalon.framework.context.Context)this._context);
                request.setAttribute("site", (Object)site.getName());
                this._tagSubscriptionType.getGroupsSubscriptions(site, null, BroadcastChannelHelper.BroadcastChannel.MAIL, Set.of(), true, null).stream().filter(s -> s.getFrequency() != FrequencyHelper.Frequency.INSTANT).forEach(s -> {
                    try {
                        this._groupTagRunnableHelper.scheduleForcedSubscription((Subscription)((Object)s));
                    }
                    catch (SchedulerException e) {
                        this._logger.error("An error occurred creating runnable for subscription with id '" + s.getId() + "'", (Throwable)e);
                    }
                });
            }
        }
        finally {
            BackgroundEngineHelper.leaveEngineEnvironment((Map)environment);
        }
    }
}

