/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.pagesubscription.type;

import java.util.List;
import java.util.Map;
import org.ametys.cms.tag.CMSTag;
import org.ametys.cms.tag.TagProviderExtensionPoint;
import org.ametys.core.group.GroupIdentity;
import org.ametys.plugins.pagesubscription.BroadcastChannelHelper;
import org.ametys.plugins.pagesubscription.FrequencyHelper;
import org.ametys.plugins.pagesubscription.Subscription;
import org.ametys.plugins.pagesubscription.context.TagSubscriptionContext;
import org.ametys.plugins.pagesubscription.dao.TagSubscriptionsDAO;
import org.ametys.plugins.pagesubscription.schedulable.tag.ForcedSubscriptionSchedulerHelper;
import org.ametys.plugins.pagesubscription.type.AbstractSubscriptionType;
import org.ametys.plugins.pagesubscription.type.SubscriptionType;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.OrExpression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.web.repository.site.Site;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.quartz.SchedulerException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class TagSubscriptionType
extends AbstractSubscriptionType<TagSubscriptionContext, CMSTag> {
    public static final String ID = "subscription.tag";
    public static final String TAG = "tag";
    protected TagProviderExtensionPoint _tagProviderEP;
    protected ForcedSubscriptionSchedulerHelper _forcedSubscriptionSchedulerHelper;
    protected TagSubscriptionsDAO _tagSubscriptionsDAO;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._tagProviderEP = (TagProviderExtensionPoint)manager.lookup(TagProviderExtensionPoint.ROLE);
        this._forcedSubscriptionSchedulerHelper = (ForcedSubscriptionSchedulerHelper)((Object)manager.lookup(ForcedSubscriptionSchedulerHelper.ROLE));
        this._tagSubscriptionsDAO = (TagSubscriptionsDAO)((Object)manager.lookup(TagSubscriptionsDAO.ROLE));
    }

    @Override
    public CMSTag getTarget(Subscription subscription) {
        return this._getTag(subscription);
    }

    @Override
    public Subscription forceSubscription(Site site, GroupIdentity group, FrequencyHelper.Frequency frequency, SubscriptionType.FrequencyTiming forcedTiming, List<BroadcastChannelHelper.BroadcastChannel> broadcastChannels, TagSubscriptionContext context) throws Exception {
        Subscription subscription = super.forceSubscription(site, group, frequency, forcedTiming, broadcastChannels, context);
        this._scheduleForcedSubscription(subscription);
        return subscription;
    }

    @Override
    public void editForceSubscription(Subscription subscription, FrequencyHelper.Frequency frequency, List<BroadcastChannelHelper.BroadcastChannel> broadcastChannels, SubscriptionType.FrequencyTiming forcedTiming, TagSubscriptionContext context) throws Exception {
        this._unscheduleForcedSubscription(subscription);
        super.editForceSubscription(subscription, frequency, broadcastChannels, forcedTiming, context);
        this._scheduleForcedSubscription(subscription);
    }

    @Override
    public void unsubscribe(Subscription subscription) throws Exception {
        this._unscheduleForcedSubscription(subscription);
        super.unsubscribe(subscription);
    }

    private void _unscheduleForcedSubscription(Subscription subscription) throws SchedulerException {
        if (this._canCreateRunnable(subscription)) {
            this._forcedSubscriptionSchedulerHelper.unscheduleForcedSubscription(subscription);
        }
    }

    private void _scheduleForcedSubscription(Subscription subscription) throws SchedulerException {
        if (this._canCreateRunnable(subscription)) {
            this._forcedSubscriptionSchedulerHelper.scheduleForcedSubscription(subscription);
        }
    }

    private boolean _canCreateRunnable(Subscription subscription) {
        return subscription.getFrequency() != FrequencyHelper.Frequency.INSTANT && subscription.getBroadcastChannels().stream().filter(c -> c == BroadcastChannelHelper.BroadcastChannel.MAIL).findAny().isPresent();
    }

    @Override
    protected void setAdditionalData(Subscription subscription, TagSubscriptionContext context) {
        subscription.setValue(TAG, context.getTagName());
    }

    @Override
    protected boolean isSubscriptionValid(Subscription subscription) {
        return this._getTag(subscription) != null;
    }

    @Override
    protected Expression getAdditionalFilterExpression(TagSubscriptionContext context) {
        String tagName = context.getTagName();
        if (tagName != null) {
            return new StringExpression(TAG, Expression.Operator.EQ, tagName);
        }
        String rootTagName = context.getRootTagName();
        String siteName = context.getSiteName();
        if (StringUtils.isNotBlank((CharSequence)rootTagName) && StringUtils.isNotBlank((CharSequence)siteName)) {
            Expression[] tagsExpr = (Expression[])this._tagSubscriptionsDAO.getAllTags(rootTagName, siteName).stream().map(t -> new StringExpression(TAG, Expression.Operator.EQ, t.getName())).toArray(Expression[]::new);
            return new OrExpression(tagsExpr);
        }
        return null;
    }

    @Override
    public Map<String, Object> subscriptionToJSON(Subscription subscription) {
        Map<String, Object> subscriptionToJSON = super.subscriptionToJSON(subscription);
        CMSTag tag = this._getTag(subscription);
        if (tag != null) {
            subscriptionToJSON.put(TAG, Map.of("label", tag.getTitle(), "name", tag.getName()));
        }
        return subscriptionToJSON;
    }

    @Override
    protected void _saxAdditionalData(ContentHandler contentHandler, Subscription subscription) throws SAXException {
        super._saxAdditionalData(contentHandler, subscription);
        CMSTag tag = this._getTag(subscription);
        if (tag != null) {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("name", tag.getName());
            XMLUtils.startElement((ContentHandler)contentHandler, (String)TAG, (Attributes)attrs);
            tag.getTitle().toSAX(contentHandler);
            XMLUtils.endElement((ContentHandler)contentHandler, (String)TAG);
        }
    }

    private CMSTag _getTag(Subscription subscription) {
        String tagName = (String)subscription.getValue(TAG);
        try {
            return (CMSTag)this._tagProviderEP.getTag(tagName, Map.of("siteName", subscription.getSite().getName()));
        }
        catch (Exception e) {
            this.getLogger().error("An error occurred getting tag for name '{}'", (Object)tagName, (Object)e);
            return null;
        }
    }

    @Override
    protected String getUserPreferenceContextId(Subscription subscription) {
        return this.getTarget(subscription).getName();
    }
}

