/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
 
AmetysFront.UserNotifications = {
    
    TAG_NOTIFICATIONS_SHOW_CONTENTS_INVOKER_SUBSCRIPTION_ATTR: 'data-ametys-tag-notifications-subscription',
    
    TAG_NOTIFICATIONS_SHOW_CONTENTS_INVOKER_DATE_ATTR: 'data-ametys-tag-notifications-date',
    
    TAG_NOTIFICATIONS_SHOW_CONTENTS_INVOKER_TAG_ATTR: 'data-ametys-tag-notifications-tag',
    
    TAG_NOTIFICATIONS_CONTENTS_SELECTOR: '[data-ametys-tag-notifications-contents]',
    
    TAG_NOTIFICATIONS_CONTENTS_TAG_SELECTOR: '[data-ametys-tag-notifications-contents-role="tag"]',
    
    TAG_NOTIFICATIONS_CONTENTS_DATE_SELECTOR: '[data-ametys-tag-notifications-contents-role="date"]',
    
    TAG_NOTIFICATIONS_CONTENTS_RESULTS_SELECTOR: '[data-ametys-tag-notifications-contents-role="results"]',
    
    DEFAULT_VIEW_NAME: 'abstract',
    
    /**
     * Get the user tags' subscription with the updated contents related to each subscription
     * @param {Function} callback the callback function to invoked after getting the notifications
     */
    getUserTagContentNotifications: function(callback)
    {
        AmetysFront.ServerComm.callMethod({
            role: 'org.ametys.plugins.pagesubscription.notification.TagNotificationsHelper',
            methodName: 'getUserContentNotifications',
            parameters: [AmetysFront.getAppParameters().siteName],
            callback: {
                handler: function(notifications) {
                    if (typeof(callback) == 'function')
			        {
			            callback(notifications)
			        }
                }
            }
        });
    },
    
    /**
     * Get all contents of a tag subscription.
     * The retrieved contents will be inserted into HTML element with data-ametys-tag-notifications-contents-role="results" attribute contained in a HTML element with data-ametys-tag-notifications-contents attribute
     * @param {HTMLElement} btnEl the element clicked to get contents. The element needs a 'data-ametys-tag-notifications-subscription' attribute with the id of subscription
     * @param {String} [viewName=abstract] The view to use for contents 
     * @param {Function} callback The callback function after getting contents of a subscription
     */
    showContentsOfSubscription: function (btnEl, viewName, callback)
    {
        // Get HTML content in ajax
        var subscriptionId = $j(btnEl).attr(AmetysFront.UserNotifications.TAG_NOTIFICATIONS_SHOW_CONTENTS_INVOKER_SUBSCRIPTION_ATTR);
        
        $j.ajax({
            url: AmetysFront.CONTEXT_PATH + "/_plugins/page-subscription/" + AmetysFront.getAppParameter('siteName') + "/" + AmetysFront.getAppParameter('sitemapLanguage') + "/subscription-contents.html",
            type: 'POST',
            dataType: "html",
            data: {
                subscriptionId: subscriptionId,
                viewName: viewName || AmetysFront.UserNotifications.DEFAULT_VIEW_NAME
            },
            success: function(data) {
                var document = new DOMParser().parseFromString(data, "text/html");
                var content = $j(document).find("body ul").html();
                
                let $contentsWrap = $j(AmetysFront.UserNotifications.TAG_NOTIFICATIONS_CONTENTS_SELECTOR);
                $contentsWrap.find(AmetysFront.UserNotifications.TAG_NOTIFICATIONS_CONTENTS_RESULTS_SELECTOR).html(content);
                
                $contentsWrap.find(AmetysFront.UserNotifications.TAG_NOTIFICATIONS_CONTENTS_DATE_SELECTOR).html($j(btnEl).attr(AmetysFront.UserNotifications.TAG_NOTIFICATIONS_SHOW_CONTENTS_INVOKER_DATE_ATTR));
                $contentsWrap.find(AmetysFront.UserNotifications.TAG_NOTIFICATIONS_CONTENTS_TAG_SELECTOR).html($j(btnEl).attr(AmetysFront.UserNotifications.TAG_NOTIFICATIONS_SHOW_CONTENTS_INVOKER_TAG_ATTR));
                
                if (typeof(callback) == 'function')
                {
                    callback(btnEl);
                }
            },
            error: function(data) {
                AmetysFront.Utils.error("{{i18n USER_NOTIFICATIONS_HELPER_TAG_NOTIFICATION_ERROR}}");
            }
        });
    }
}
