/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.pagesubscription.schedulable.tag;

import java.util.List;
import java.util.Map;
import java.util.Set;

import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;

import org.ametys.cms.tag.CMSTag;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.core.schedule.Scheduler;
import org.ametys.plugins.pagesubscription.FrequencyHelper;
import org.ametys.plugins.pagesubscription.FrequencyHelper.Frequency;
import org.ametys.plugins.pagesubscription.Subscription;
import org.ametys.plugins.pagesubscription.type.SubscriptionType.FrequencyTiming;
import org.ametys.web.repository.site.Site;

/**
 * Schedulable to send group tag notification summary by mail
 */
public class SendGroupTagNotificationSummarySchedulable extends AbstractSendTagNotificationSummarySchedulable
{
    @Override
    protected List<Site> getSiteToNotify(JobExecutionContext context)
    {
        Subscription subscription = _getSubscription(context);
        return List.of(subscription.getSite());
    }
    
    @Override
    protected Frequency getFrequency(JobExecutionContext context)
    {
        Subscription subscription = _getSubscription(context);
        return subscription.getFrequency();
    }

    @Override
    protected FrequencyTiming getFrequencyTiming(JobExecutionContext context)
    {
        Subscription subscription = _getSubscription(context);
        return FrequencyHelper.getTiming(subscription);
    }
    
    @Override
    protected Map<CMSTag, Set<UserIdentity>> getSubscribersByTag(JobExecutionContext context, Site site, Frequency frequency)
    {
        Subscription subscription = _getSubscription(context);
        
        return Map.of(
            _tagSubscriptionType.getTarget(subscription),
            _tagSubscriptionType.getSubscribers(subscription)
        );
    }
    
    private Subscription _getSubscription(JobExecutionContext context)
    {
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        String subscriptionId = (String) jobDataMap.get(Scheduler.PARAM_VALUES_PREFIX + "subscriptionId");
        return _resolver.resolveById(subscriptionId);
    }
}
