/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.queriesdirectory.actions;

import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.queriesdirectory.Query;
import org.ametys.plugins.queriesdirectory.QueryContainer;
import org.ametys.plugins.queriesdirectory.QueryDAO;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class GetQueriesAction
extends ServiceableAction {
    private CurrentUserProvider _userProvider;
    private AmetysObjectResolver _resolver;
    private QueryDAO _queryDAO;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._userProvider = (CurrentUserProvider)serviceManager.lookup(CurrentUserProvider.ROLE);
        this._resolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
        this._queryDAO = (QueryDAO)((Object)serviceManager.lookup(QueryDAO.ROLE));
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Map jsParameters = (Map)objectModel.get("parent-context");
        String profileId = (String)StringUtils.defaultIfEmpty((CharSequence)((String)jsParameters.get("profile")), (CharSequence)"read_access");
        List acceptedQueryTypes = (List)jsParameters.get("acceptedQueryTypes");
        if (!("read_access".equals(profileId) || "write_access".equals(profileId) || "right_access".equals(profileId))) {
            throw new IllegalArgumentException("Unexpected profile identifier : " + profileId);
        }
        Query.QueryProfile profile = Query.QueryProfile.valueOf(profileId.toUpperCase());
        QueryContainer parentContainer = this._getParentContainer(jsParameters);
        Boolean onlyContainers = jsParameters.getOrDefault("onlyContainers", Boolean.FALSE);
        Boolean onlyQueries = onlyContainers != false ? false : jsParameters.getOrDefault("onlyQueries", Boolean.FALSE);
        Boolean testIfEmptyContainer = jsParameters.getOrDefault("testIfEmptyContainer", Boolean.FALSE);
        Boolean allDescendants = jsParameters.getOrDefault("allDescendants", Boolean.FALSE);
        UserIdentity user = this._userProvider.getUser();
        ArrayList nodes = new ArrayList();
        Stream<Query> childQueriesStream = onlyContainers != false ? Stream.empty() : this._getChildQueries(parentContainer, allDescendants == false, acceptedQueryTypes, profile, user);
        childQueriesStream.map(this._queryDAO::getQueryProperties).forEach(nodes::add);
        Stream<Pair> childContainersStream = onlyQueries != false ? Stream.empty() : this._getChildQueryContainers(parentContainer, testIfEmptyContainer, acceptedQueryTypes, profile, user);
        childContainersStream.forEach(p -> {
            QueryContainer queryContainer = (QueryContainer)((Object)((Object)p.getLeft()));
            Map<String, Object> properties = this._queryDAO.getQueryContainerProperties(queryContainer);
            AdditionalInfoOnContainer additionalInfo = (AdditionalInfoOnContainer)p.getRight();
            additionalInfo.fillAdditionalInfo(properties);
            switch (profile) {
                case WRITE_ACCESS: {
                    if (!((Boolean)properties.get("canWrite")).booleanValue() && !this._queryDAO.hasAnyWritableDescendant(user, queryContainer).booleanValue()) break;
                    nodes.add(properties);
                    break;
                }
                case RIGHT_ACCESS: {
                    if (!((Boolean)properties.get("canAssignRights")).booleanValue() && !this._queryDAO.hasAnyAssignableDescendant(user, queryContainer)) break;
                    nodes.add(properties);
                    break;
                }
                default: {
                    if (!((Boolean)properties.get("canRead")).booleanValue() && !this._queryDAO.hasAnyReadableDescendant(user, queryContainer)) break;
                    nodes.add(properties);
                }
            }
        });
        HashMap result = new HashMap();
        result.put("queries", nodes);
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        return EMPTY_MAP;
    }

    private QueryContainer _getParentContainer(Map jsParameters) {
        com.google.common.base.Predicate isNotRoot = Predicates.not((com.google.common.base.Predicate)Predicates.equalTo((Object)"root"));
        QueryContainer parent = Optional.of("node").map(jsParameters::get).filter(String.class::isInstance).map(String.class::cast).filter((Predicate<String>)isNotRoot).map(arg_0 -> ((AmetysObjectResolver)this._resolver).resolveById(arg_0)).orElse(this._queryDAO.getQueriesRootNode());
        return parent;
    }

    private Stream<Pair<QueryContainer, AdditionalInfoOnContainer>> _getChildQueryContainers(QueryContainer parentContainer, boolean testIfEmptyContainer, List<String> acceptedQueryTypes, Query.QueryProfile profile, UserIdentity user) {
        AmetysObjectIterable<QueryContainer> childQueryContainers = this._queryDAO.getChildQueryContainers(parentContainer);
        Stream childQueryContainersStream = childQueryContainers.stream();
        if (testIfEmptyContainer) {
            return childQueryContainersStream.map(ct -> Pair.of((Object)ct, (Object)new AdditionalInfoOnContainer(this._hasNoDescendant((QueryContainer)((Object)ct), acceptedQueryTypes, profile, user))));
        }
        return childQueryContainersStream.map(ct -> Pair.of((Object)ct, (Object)new AdditionalInfoOnContainer()));
    }

    private Boolean _hasNoDescendant(QueryContainer queryContainer, List<String> acceptedQueryTypes, Query.QueryProfile profile, UserIdentity user) {
        boolean onlyDirectChildren = false;
        Stream<Query> childQueries = this._getChildQueries(queryContainer, onlyDirectChildren, acceptedQueryTypes, profile, user);
        return !childQueries.findAny().isPresent();
    }

    private Stream<Query> _getChildQueries(QueryContainer parentContainer, boolean onlyDirectChildren, List<String> acceptedQueryTypes, Query.QueryProfile profile, UserIdentity user) {
        return switch (profile) {
            case Query.QueryProfile.WRITE_ACCESS -> this._queryDAO.getChildQueriesInWriteAccess(parentContainer, onlyDirectChildren, user, acceptedQueryTypes);
            case Query.QueryProfile.RIGHT_ACCESS -> this._queryDAO.getChildQueriesInRightAccess(parentContainer, onlyDirectChildren, user, acceptedQueryTypes);
            default -> this._queryDAO.getChildQueriesInReadAccess(parentContainer, onlyDirectChildren, user, acceptedQueryTypes);
        };
    }

    private static class AdditionalInfoOnContainer {
        private Optional<Boolean> _hasNoDescendant = Optional.empty();

        AdditionalInfoOnContainer() {
        }

        AdditionalInfoOnContainer(boolean hasNoDescendant) {
            this._hasNoDescendant = Optional.of(hasNoDescendant);
        }

        void fillAdditionalInfo(Map<String, Object> props) {
            this._hasNoDescendant.ifPresent(b -> props.put("hasNoDescendantQuery", b));
        }
    }
}

