/*
 *  Copyright 2016 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class is the solr query model.
 * @private
 */
Ext.define('Ametys.plugins.queriesdirectory.model.SolrQuery', {
	extend: 'Ametys.plugins.queriesdirectory.model.AbstractQuery',
	
	statics :
	{
		/**
		 * @private
		 * @property {String} [QUERY_TYPE="simple"] The query type
		 */
		QUERY_TYPE: 'solr'
	},
	
	/**
	 * Get the type of the label
	 * @return {String} the type of the label
	 */
	getTypeLabel: function ()
	{
		return "{{i18n PLUGINS_QUERIESDIRECTORY_UITOOL_QUERIES_TYPE_SOLR}}";
	},
    
    getTypeIconCls: function()
    {
        return 'ametysicon-solr';  
    },
	
	/**
	 * Function to open the query
	 */
	open : function()
	{
		var content = Ext.JSON.decode(this.content);

		var toolId = content.toolId;
		var toolParams = content.toolParams || {};
		toolParams.expanded = true;
		toolParams.readOnly = this.readOnly;
        toolParams.queryId = this.queryId;
        toolParams.solrSearchToolId = this.queryId;
		
		Ametys.tool.ToolsManager.openTool(toolId, toolParams);
	},
	
	/**
	 * Function to execute the query
	 */
	execute : function()
	{
		var content = Ext.JSON.decode(this.content);

		var toolId = content.toolId;
		var toolParams = content.toolParams || {};
		toolParams.startSearchAtOpening = true;
		toolParams.readOnly = this.readOnly;
        toolParams.queryId = this.queryId;
        toolParams.solrSearchToolId = this.queryId;
		
		Ametys.tool.ToolsManager.openTool(toolId, toolParams);
	}
});
Ametys.plugins.queriesdirectory.model.QueryFactory.registerQuery (Ametys.plugins.queriesdirectory.model.SolrQuery.QUERY_TYPE, Ametys.plugins.queriesdirectory.model.SolrQuery);