/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * Convert a query or query container MessageTarget into right context.
 */
Ext.define('Ametys.plugins.queriesdirectory.QueryTargetToContextConvertor', {
    extend: 'Ametys.plugins.coreui.rights.AbstractTargetToContextConvertor',
    
    isSupportedTarget: function(target)
    {
        return target != null &&
            (target.getId() == Ametys.message.MessageTarget.QUERY
            || target.getId() == Ametys.message.MessageTarget.QUERY_CONTAINER);
    },
    
    convert: function(target, parameters)
    {
        return target.getParameters().id;
    },
    
    getContextInfo:function(target, parameters)
    {
        if (target.getId() == Ametys.message.MessageTarget.QUERY)
        {
            return {label: target.getParameters().title, type: '{{i18n PLUGINS_QUERIESDIRECTORY_QUERY_TARGET_CONVERTOR_QUERY_TYPE_LABEL}}'};
        }
        else
        {
            return {label: target.getParameters().name, type: '{{i18n PLUGINS_QUERIESDIRECTORY_QUERY_TARGET_CONVERTOR_CONTAINER_TYPE_LABEL}}'};
        }
    }
});

