/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.queriesdirectory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.jcr.RepositoryException;
import org.ametys.cms.repository.Content;
import org.ametys.cms.search.SortOrder;
import org.ametys.cms.search.content.ContentSearcherFactory;
import org.ametys.cms.search.model.SearchModel;
import org.ametys.cms.search.ui.model.SearchUIModel;
import org.ametys.cms.search.ui.model.SearchUIModelExtensionPoint;
import org.ametys.core.util.JSONUtils;
import org.ametys.plugins.queriesdirectory.Query;
import org.ametys.plugins.queriesdirectory.QueryContainer;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.OrExpression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.jackrabbit.util.ISO9075;

public class QueryHelper
extends AbstractLogEnabled
implements Serviceable,
Component {
    public static final String ROLE = QueryHelper.class.getName();
    protected AmetysObjectResolver _resolver;
    protected JSONUtils _jsonUtils;
    protected SearchUIModelExtensionPoint _searchUiEP;
    protected ContentSearcherFactory _contentSearcherFactory;
    protected ServiceManager _manager;

    public void service(ServiceManager manager) throws ServiceException {
        this._manager = manager;
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._jsonUtils = (JSONUtils)manager.lookup(JSONUtils.ROLE);
        this._searchUiEP = (SearchUIModelExtensionPoint)manager.lookup(SearchUIModelExtensionPoint.ROLE);
        this._contentSearcherFactory = (ContentSearcherFactory)manager.lookup(ContentSearcherFactory.ROLE);
    }

    static String getXPathForQueryContainers(QueryContainer queryContainer) {
        return QueryHelper._getXPathQuery(queryContainer, true, ObjectToReturn.QUERY_CONTAINER, List.of());
    }

    static String getXPathForQueriesForAdministrator(QueryContainer queryContainer, boolean onlyDirectChildren, List<String> acceptedTypes) {
        return QueryHelper._getXPathQuery(queryContainer, onlyDirectChildren, ObjectToReturn.QUERY, acceptedTypes);
    }

    static String getXPathForQueries(QueryContainer queryContainer, boolean onlyDirectChildren, List<String> acceptedTypes) {
        return QueryHelper._getXPathQuery(queryContainer, onlyDirectChildren, ObjectToReturn.QUERY, acceptedTypes);
    }

    private static StringBuilder _getParentPath(QueryContainer queryContainer) {
        try {
            StringBuilder parentPath = new StringBuilder("/jcr:root").append(ISO9075.encodePath((String)queryContainer.getNode().getPath()));
            return parentPath;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException((Throwable)e);
        }
    }

    private static String _getXPathQuery(QueryContainer queryContainer, boolean onlyDirectChildren, ObjectToReturn objectToReturn, List<String> acceptedTypes) {
        StringBuilder parentPath = QueryHelper._getParentPath(queryContainer);
        String slashOrDoubleSlash = onlyDirectChildren ? "/" : "//";
        StringBuilder query = parentPath.append(slashOrDoubleSlash).append("element(*, ").append(objectToReturn.toNodetype()).append(")");
        if (acceptedTypes != null && !acceptedTypes.isEmpty()) {
            ArrayList<StringExpression> exprs = new ArrayList<StringExpression>();
            for (String type : acceptedTypes) {
                exprs.add(new StringExpression("type", Expression.Operator.EQ, type));
            }
            OrExpression typeExpression = new OrExpression(exprs.toArray(new Expression[exprs.size()]));
            query.append("[").append(typeExpression.build()).append("]");
        }
        return query.toString();
    }

    public AmetysObjectIterable<Content> executeQuery(String queryId) throws Exception {
        AmetysObject ametysObject = this._resolver.resolveById(queryId);
        if (ametysObject instanceof Query) {
            return this.executeQuery((Query)ametysObject);
        }
        return null;
    }

    public AmetysObjectIterable<Content> executeQuery(Query query) throws Exception {
        Map<String, Object> exportParams = this.getExportParams(query);
        int limit = this.getLimitForQuery(exportParams);
        List<ContentSearcherFactory.ContentSearchSort> sort = this.getSortForQuery(exportParams);
        String model = this.getModelForQuery(exportParams);
        if ("solr".equals(query.getType())) {
            String queryStr = this.getQueryStringForQuery(exportParams);
            Set contentTypeIds = this.getContentTypesForQuery(exportParams).stream().collect(Collectors.toSet());
            AmetysObjectIterable results = this._contentSearcherFactory.create(contentTypeIds).withSort(sort).withLimits(0, limit).search(queryStr);
            return results;
        }
        if (Query.Type.SIMPLE.toString().equals(query.getType()) || Query.Type.ADVANCED.toString().equals(query.getType())) {
            Map<String, Object> values = this.getValuesForQuery(exportParams);
            Map<String, Object> contextualParameters = this.getContextualParametersForQuery(exportParams);
            String searchMode = this.getSearchModeForQuery(exportParams);
            SearchUIModel uiModel = (SearchUIModel)this._searchUiEP.getExtension(model);
            ContentSearcherFactory.SearchModelContentSearcher searcher = this._contentSearcherFactory.create((SearchModel)uiModel);
            return searcher.withLimits(0, limit).withSort(sort).withSearchMode(searchMode).search(values, contextualParameters);
        }
        this.getLogger().warn("This method should only handle solr, advanced or simple queries. Query id '{}' is type '{}'", (Object)query.getId(), (Object)query.getType());
        return null;
    }

    public int getLimitForQuery(Map<String, Object> exportParams) {
        return Optional.of("limit").map(exportParams::get).map(Integer.class::cast).filter(l -> l >= 0).orElse(Integer.MAX_VALUE);
    }

    public String getModelForQuery(Map<String, Object> exportParams) {
        if (exportParams.containsKey("model")) {
            return (String)exportParams.get("model");
        }
        return null;
    }

    public Map<String, Object> getValuesForQuery(Map<String, Object> exportParams) {
        if (exportParams.containsKey("values")) {
            Map values = (Map)exportParams.get("values");
            return values;
        }
        return null;
    }

    public Map<String, Object> getContextualParametersForQuery(Map<String, Object> exportParams) {
        if (exportParams.containsKey("contextualParameters")) {
            Map contextualParameters = (Map)exportParams.get("contextualParameters");
            return contextualParameters;
        }
        return null;
    }

    public List<ContentSearcherFactory.ContentSearchSort> getSortForQuery(Map<String, Object> exportParams) {
        if (exportParams.containsKey("sort")) {
            String sortString = (String)exportParams.get("sort");
            List sortlist = this._jsonUtils.convertJsonToList(sortString);
            return sortlist.stream().map(Map.class::cast).map(map -> new ContentSearcherFactory.ContentSearchSort((String)map.get("property"), SortOrder.valueOf((String)((String)map.get("direction"))))).collect(Collectors.toList());
        }
        return null;
    }

    public List<String> getContentTypesForQuery(Map<String, Object> exportParams) {
        Map<String, Object> values = this.getValuesForQuery(exportParams);
        if (values.containsKey("contentTypes")) {
            List contentTypes = (List)values.get("contentTypes");
            return contentTypes;
        }
        return null;
    }

    public String getQueryStringForQuery(Map<String, Object> exportParams) {
        Map<String, Object> values = this.getValuesForQuery(exportParams);
        if (values.containsKey("query")) {
            return (String)values.get("query");
        }
        return null;
    }

    public String getSearchModeForQuery(Map<String, Object> exportParams) {
        if (exportParams.containsKey("searchMode")) {
            return (String)exportParams.get("searchMode");
        }
        return "simple";
    }

    public Map<String, Object> getExportParams(Query query) {
        Object exportParams;
        String queryContent = query.getContent();
        Map jsonMap = this._jsonUtils.convertJsonToMap(queryContent);
        if (jsonMap.containsKey("exportParams") && (exportParams = jsonMap.get("exportParams")) instanceof Map) {
            Map exportParamsObject = (Map)exportParams;
            return exportParamsObject;
        }
        return new HashMap<String, Object>();
    }

    private static enum ObjectToReturn {
        QUERY,
        QUERY_CONTAINER;

        private String _nodetype;

        String toNodetype() {
            return this._nodetype;
        }

        static {
            ObjectToReturn.QUERY._nodetype = "ametys:query";
            ObjectToReturn.QUERY_CONTAINER._nodetype = "ametys:queries";
        }
    }
}

