/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.queriesdirectory.accesscontroller;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.right.AccessController;
import org.ametys.core.right.AccessExplanation;
import org.ametys.core.right.RightsException;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.core.impl.right.AbstractRightBasedAccessController;
import org.ametys.plugins.queriesdirectory.Query;
import org.ametys.plugins.queriesdirectory.QueryContainer;
import org.ametys.plugins.queriesdirectory.accesscontroller.QueryAccessController;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.query.QueryHelper;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.UserExpression;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.collections.MapUtils;

public class QueryAuthorAccessController
extends AbstractRightBasedAccessController
implements Serviceable {
    private static final List<String> __CREATOR_RIGHTS = List.of("QueriesDirectory_Rights_Admin");
    protected AmetysObjectResolver _resolver;

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
    }

    public boolean supports(Object object) {
        return object instanceof Query;
    }

    public AccessController.AccessResult getPermission(UserIdentity user, Set<GroupIdentity> userGroups, String rightId, Object object) {
        if (((Query)((Object)object)).getAuthor().equals((Object)user)) {
            return __CREATOR_RIGHTS.contains(rightId) ? AccessController.AccessResult.USER_ALLOWED : AccessController.AccessResult.UNKNOWN;
        }
        return AccessController.AccessResult.UNKNOWN;
    }

    public AccessController.AccessResult getReadAccessPermission(UserIdentity user, Set<GroupIdentity> userGroups, Object object) {
        return ((Query)((Object)object)).getAuthor().equals((Object)user) ? AccessController.AccessResult.USER_ALLOWED : AccessController.AccessResult.UNKNOWN;
    }

    public Map<String, AccessController.AccessResult> getPermissionByRight(UserIdentity user, Set<GroupIdentity> userGroups, Object object) {
        HashMap<String, AccessController.AccessResult> permissionByRight = new HashMap<String, AccessController.AccessResult>();
        if (((Query)((Object)object)).getAuthor().equals((Object)user)) {
            for (String rightId : __CREATOR_RIGHTS) {
                permissionByRight.put(rightId, AccessController.AccessResult.USER_ALLOWED);
            }
        }
        return permissionByRight;
    }

    public AccessController.AccessResult getPermissionForAnonymous(String rightId, Object object) {
        return AccessController.AccessResult.UNKNOWN;
    }

    public AccessController.AccessResult getReadAccessPermissionForAnonymous(Object object) {
        return AccessController.AccessResult.UNKNOWN;
    }

    public AccessController.AccessResult getPermissionForAnyConnectedUser(String rightId, Object object) {
        return AccessController.AccessResult.UNKNOWN;
    }

    public AccessController.AccessResult getReadAccessPermissionForAnyConnectedUser(Object object) {
        return AccessController.AccessResult.UNKNOWN;
    }

    public Map<UserIdentity, AccessController.AccessResult> getPermissionByUser(String rightId, Object object) {
        HashMap<UserIdentity, AccessController.AccessResult> permissionByUser = new HashMap<UserIdentity, AccessController.AccessResult>();
        if (__CREATOR_RIGHTS.contains(rightId)) {
            permissionByUser.put(((Query)((Object)object)).getAuthor(), AccessController.AccessResult.USER_ALLOWED);
        }
        return permissionByUser;
    }

    public Map<UserIdentity, AccessController.AccessResult> getReadAccessPermissionByUser(Object object) {
        return MapUtils.EMPTY_MAP;
    }

    public Map<GroupIdentity, AccessController.AccessResult> getPermissionByGroup(String rightId, Object object) {
        return MapUtils.EMPTY_MAP;
    }

    public Map<GroupIdentity, AccessController.AccessResult> getReadAccessPermissionByGroup(Object object) {
        return MapUtils.EMPTY_MAP;
    }

    public boolean hasUserAnyPermissionOnWorkspace(Set<Object> workspacesContexts, UserIdentity user, Set<GroupIdentity> userGroups, String rightId) {
        return false;
    }

    public boolean hasUserAnyReadAccessPermissionOnWorkspace(Set<Object> workspacesContexts, UserIdentity user, Set<GroupIdentity> userGroups) {
        return false;
    }

    public boolean hasAnonymousAnyPermissionOnWorkspace(Set<Object> workspacesContexts, String rightId) {
        return false;
    }

    public boolean hasAnonymousAnyReadAccessPermissionOnWorkspace(Set<Object> workspacesContexts) {
        return false;
    }

    public boolean hasAnyConnectedUserAnyPermissionOnWorkspace(Set<Object> workspacesContexts, String rightId) {
        return false;
    }

    public boolean hasAnyConnectedUserAnyReadAccessPermissionOnWorkspace(Set<Object> workspacesContexts) {
        return false;
    }

    protected AccessExplanation _getAccessExplanation(AccessController.AccessResult result, Object object, UserIdentity user, Set<GroupIdentity> groups, String rightId) {
        switch (result) {
            case USER_ALLOWED: 
            case UNKNOWN: {
                return new AccessExplanation(this.getId(), result, new I18nizableText("plugin.queries-directory", "PLUGINS_QUERIESDIRECTORY_QUERY_AUTHOR_ACCESS_CONTROLLER_" + result.name() + "_EXPLANATION", Map.of("title", this.getObjectLabel(object))));
            }
        }
        return AccessController.getDefaultAccessExplanation((String)this.getId(), (AccessController.AccessResult)result);
    }

    protected Iterable<? extends Object> getHandledObjects(UserIdentity identity, Set<GroupIdentity> groups, Set<Object> workspacesContexts) {
        if (workspacesContexts.contains("/cms")) {
            String xPathQuery = QueryHelper.getXPathQuery(null, (String)"ametys:query", (Expression)new UserExpression("author", Expression.Operator.EQ, identity));
            return this._resolver.query(xPathQuery);
        }
        return List.of();
    }

    protected Collection<String> getHandledRights() {
        return __CREATOR_RIGHTS;
    }

    public I18nizableText getObjectLabel(Object object) {
        if (object instanceof Query) {
            Query query = (Query)((Object)object);
            return new I18nizableText(QueryAccessController.getQueryContainerParentPathLabel((QueryContainer)query.getParent()) + query.getTitle());
        }
        throw new RightsException("Unsupported context: " + object.toString());
    }

    public I18nizableText getObjectCategory(Object object) {
        return QueryAccessController.QUERIES_DIRECTORY_CONTEXT_CATEGORY;
    }
}

