/*
 *  Copyright 2013 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This factory creates Ametys.message.MessageTarget for a query.
 * See #createTargets for more details.
 * @private
 */
Ext.define('Ametys.plugins.queriesdirectory.QueryMessageTargetFactory', {
	extend: 'Ametys.message.factory.DefaultMessageTargetFactory',
		
	/**
	 * Create the targets for a message
	 * @param {Object} parameters The parameters needed by the factory to create the message. Can not be null. Handled elements are
	 * @param {String[]} parameters.ids The query's identifiers.
	 * @param {Function} callback The callback function called when the targets are created. Parameters are
	 * @param {Ametys.message.MessageTarget[]} callback.targets The targets created. Cannot be null.
	 */
    createTargets: function(parameters, callback)
    {
        if (parameters.ids || parameters.id)
        {
            var ids = parameters.ids || Ext.Array.from(parameters.id);
            Ametys.plugins.queriesdirectory.QueriesDAO.getQueries(ids, Ext.bind(this._createTargets, this, [callback, parameters], 1));
        }
        else if (parameters.queries)
        {
            this._createTargets (parameters.queries, callback, parameters);
        }
    },

	/**
	 * Create the queries targets
	 * @param {Object[]} queries Array of query data objects.
	 * @param {Function} callback The callback function called when the targets are created. Parameters are
	 * @param {Ametys.message.MessageTarget[]} callback.targets The targets created. Cannot be null.
     * @param {Object[]} parameters The parameters
	 * @private
	 */
	_createTargets: function (queries, callback, parameters)
	{
        delete parameters['ids'];
        delete parameters['queries'];
        
        var targets = [];
        
        Ext.Array.forEach(queries, function(query) {
            
            targets.push(Ext.create("Ametys.message.MessageTarget", {
                id: Ametys.message.MessageTarget.QUERY,
                parameters: Ext.merge(query.getProperties(parameters || {}), {query: query})
            }));
        }, this);
            
        callback(targets);
	}
});

Ext.define("Ametys.message.QueryMessageTarget",
    {
        override: "Ametys.message.MessageTarget",
        
        statics: 
        {
            /**
             * @member Ametys.message.MessageTarget
             * @readonly
             * @property {String} QUERY The target type is a query. Ametys.plugins.queriesdirectory.QueryMessageTargetFactory parameters to know more of the associated parameters. 
             * @property {Ametys.message.MessageTarget[]} QUERY.selection The selection message targets for the query. 
             */
            QUERY: "query",
            /**
             * @member Ametys.message.MessageTarget
             * @readonly
             * @property {String} QUERY_CONTAINER The target type is a query container. The expected parameters are:  
             * @property {String} QUERY_CONTAINER.id The id of the query container
             * @property {String} QUERY_CONTAINER.canWrite true if the current user can write inside the query container
             * @property {String} QUERY_CONTAINER.canRename true if the current user can rename the query container
             * @property {String} QUERY_CONTAINER.canDelete true if the current user can move or delete the query container
             * @property {String} QUERY_CONTAINER.canAssignRights true if the current user can edit the rights of the query container
             * @property {String} QUERY_CONTAINER.fullPath The full path of the query container
             */
            QUERY_CONTAINER: "query-container"
        }
    }
);