/*
 *  Copyright 2013 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class controls a read-only input representing the value of current selected query's id
 * @private
 */
Ext.define('Ametys.plugins.queriesdirectory.controllers.QueryIdentifierController', {
	extend: 'Ametys.ribbon.element.ui.FieldController',
	
	constructor: function (config)
	{
		this.callParent(arguments);
		
		Ametys.message.MessageBus.on(Ametys.message.Message.SELECTION_CHANGED, this._onSelectionChanged, this);
	},
	
	/**
	 * Listener on selection changed event
	 * @param {Ametys.message.Message} message The selection message
	 * @private
	 */
	_onSelectionChanged: function(message)
	{
		message = message || Ametys.message.MessageBus.getCurrentSelectionMessage();
		
        var target = message.getTarget(Ametys.message.MessageTarget.QUERY);
        var targetContainer = message.getTarget(Ametys.message.MessageTarget.QUERY_CONTAINER);
		
		if (target != null && target.getParameters().type != Ametys.plugins.queriesdirectory.model.QueryFormatting.FORMATTING_TYPE)
		{
            this.setDisabled(false);
            this.setAdditionalDescription(null);
			this.setValue(target.getParameters().id);
		}
        else if (targetContainer != null)
        {
            this.setDisabled(false);
            this.setAdditionalDescription(null);
            this.setValue(targetContainer.getParameters().id);
        }
		else
		{
            this.setDisabled(true);
			this.setValue();
            this.setAdditionalDescription(target == null ? "{{i18n PLUGINS_QUERIESDIRECTORY_QUERY_IDENTIFIER_NO_SELECTION}}" : "{{i18n PLUGINS_QUERIESDIRECTORY_QUERY_IDENTIFIER_FORMATTING_QUERY}}");
		}
	}
});

