/*
 *  Copyright 2013 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class controls a ribbon button that is able to check for conditions on
 * the visibility of a Query.
 * @private
 */
Ext.define('Ametys.plugins.queriesdirectory.controllers.QueryVisibilityGallery', {
	extend: 'Ametys.plugins.queriesdirectory.controllers.QueryController',
	
	/**
	 * @inheritdoc
	 * Add a listener on 'menushow' event
	 */
	createUI: function ()
	{
		var elt = this.callParent(arguments);
		elt.on ('menushow', this._onMenuShow, this);
		return elt;
	},
	
	/**
	 * Listener on 'menushow' event<br>
	 * @param {Ext.button.Button} btn The button
	 * @param {Ext.menu.Menu} menu The menu
	 * @private
	 */
	_onMenuShow: function (btn, menu)
	{
		var message = Ametys.message.MessageBus.getCurrentSelectionMessage();
        
        var target = message.getTarget(Ametys.message.MessageTarget.QUERY);
        
        var me = this;
        this._getGalleries(btn).each (function (gallery) {
            gallery.items.each(function (item) {
                var itemVisibility = Ametys.ribbon.RibbonManager.getUI(item.controlId).initialConfig.visibility;
                item.toggle(target != null && target.getParameters().visibility == itemVisibility, true);
            });
        });
	},
	
	/**
	 * Listener on modified message.
	 * Update the state of the controller accordingly.
	 * @param {Ametys.message.Message} message the message of type modified.
	 * @private
	 */
	_onQueryModified: function(message)
	{
		if (this.updateTargetsInCurrentSelectionTargets (message))
		{
			this._updateIcons();
		}
	},
	
	/**
	 * Update the icons according the visibility attribute
	 * @private
	 */
	_updateIcons: function ()
	{
		var targets = this.getMatchingTargets();
        if (targets.length == 0)
        {
            this.setGlyphIcon('ametysicon-data110');
            this.setIconDecorator('decorator-ametysicon-eye-blocked');
        }
        else
        {
            var visibility = targets[0].getParameters().visibility;
            
            var iconGlyph, iconDecorator, iconDecoratorType;
            this._getGalleries().each(function (gallery) {
                gallery.items.each(function(menuItem) {
                    var controller = Ametys.ribbon.RibbonManager.getUI(menuItem.controlId);
                    var menuItemVisibility = controller.getInitialConfig("visibility");
                    if (menuItemVisibility == visibility)
                    {
                        iconGlyph = controller.getInitialConfig("icon-glyph");
                        iconDecorator = controller.getInitialConfig("icon-decorator");
                        iconDecoratorType = controller.getInitialConfig("icon-decorator-type");
                    }
                })
            });
            
            if (iconGlyph && iconDecorator && iconDecoratorType)
            {
                this.setGlyphIcon(iconGlyph);
                this.setIconDecorator(iconDecorator);
                this.setIconDecoratorType(iconDecoratorType);
            }
        }
	},
	
	/**
	 * @inheritdoc
	 */
	_onSelectionChanged: function (message)
	{
		this.callParent (arguments);
		this._updateIcons();
	}
});
