/*
 *  Copyright 2013 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class controls a open tool ribbon button that is able to check for conditions on
 * the rights of a Query.
 * @private
 */
Ext.define('Ametys.plugins.queriesdirectory.controllers.OpenQueryRightsToolController', {
	extend: 'Ametys.ribbon.element.ui.button.OpenToolButtonController',

	/**
	 * @cfg {String} [enable-on-writeaccess-only="false"] If 'true' the button will be disabled as soon as the current user has no write access on query selection
	 */
	/**
	 * @cfg {String} description-no-writeaccess The description when the current user has no write access on query selection but #cfg-enable-on-writeaccess-only is true.
	 */
	
	constructor: function (config)
	{
		this.callParent(arguments);
		Ametys.message.MessageBus.on(Ametys.message.Message.MODIFIED, this._onQueryModified, this);
	},
	
	additionalErrorDescriptionOnSelectionChanged: function(targets)
	{
		var enabledOnRightAccessOnly = this.getInitialConfig("enable-on-rightaccess-only") == 'true';
        if (enabledOnRightAccessOnly && !targets[0].getParameters().canAssignRights)
        {
            return this.getInitialConfig('description-no-rightaccess') || '';
        }
	},
	
	/**
	 * Listener on modified message.
	 * Update the state of the controller accordingly.
	 * @param {Ametys.message.Message} message the message of type modified.
	 * @private
	 */
	_onQueryModified: function(message)
	{
		this.updateTargetsInCurrentSelectionTargets (message);
	}
});
	
