/*
 *  Copyright 2014 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * Abstract Query Class
 * @private
 */
Ext.define('Ametys.plugins.queriesdirectory.model.AbstractQuery', {
	
	/**
	 * @property {Object} content The query content
	 */
    
    /**
     * @property {Object} queryId The query identifier
     */
	
	/**
	 * @property {Boolean} readOnly true for read-only mode
	 */
	
	constructor: function (content, readOnly)
	{
		this.content = content;
		this.readOnly = readOnly === true;
		this.callParent(arguments);
	},
	
	/**
	 * Get the label of the type of query
	 * @return {String} the label
	 */
	getTypeLabel: function ()
	{
		throw "Unimplemented method.";
	},
    
    /**
     * Get the CSS class for the icon associated for this query
     * @return {String} the CSS icon
     */
    getTypeIconCls: function()
    {
        throw "Unimplemented method.";
    },
	
	/**
	 * Function to open the query
	 * @template
	 */
	open : function()
	{
        throw "Unimplemented method.";
	},
	
	/**
	 * Function to execute the query
	 * @template
	 */
	execute : function()
	{
        throw "Unimplemented method.";
	},
	
    /**
     * Set the identifier of the query
     * @param {String} queryId The id of query
     */
    setQueryId: function(queryId)
    {
        this.queryId = queryId;
    },
    
	/**
	 * Set the optionnal title.
	 * Title is not always present, but can be used by some query if desired.
	 * The query should check that title is not undefined or null.
	 */
	setTitle: function(title)
	{
		this.title = title;
	}
});
