/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */


/**
 * This class is the data model for query entries.
 * @private
 */
Ext.define('Ametys.plugins.queriesdirectory.tree.QueriesTree.QueryEntry', {
	extend: 'Ext.data.Model',
	
	fields: [
		'id',
		{name: 'isQuery', type: 'boolean'},
		{name: 'hasNoDescendantQuery', type: 'boolean'},
		{name: 'type', type: 'string'},
		{name: 'text', type: 'string', mapping: 'title'},
        {name: 'fullPath', type: 'string'},
        'author',
        {
            name: 'authorFullName', 
            type: 'string',
            calculate: function (data) {
                return data.author ? data.author.sortablename: '';
            }
        },
        'contributor',
        {
            name: 'contributorFullName', 
            type: 'string',
            calculate: function (data) {
                return data.contributor ? data.contributor.sortablename: '';
            }
        },
        
        {name: 'lastModificationDate', type:'date', dateFormat:'c'},
        {name: 'creationDate', type:'date', dateFormat:'c'},
        {name: 'description', type:'string'},
        {name: 'documentation', type:'string'},
		{name: 'content', type: 'string'},
        {name: 'canRead', type: 'boolean', defaultValue: false},
        {name: 'canWrite', type: 'boolean', defaultValue: false},
        {name: 'canRename', type: 'boolean', defaultValue: false},
        {name: 'canDelete', type: 'boolean', defaultValue: false},
        {name: 'canAssignRights', type: 'boolean', defaultValue: false},
        {
            name: 'leaf', 
            type: 'boolean', 
            calculate: function(data) {
                return data.isQuery;
            }
        },
        {
            name: 'iconCls',
            calculate: function (data)
            {
                return data.isQuery ? 'no-icon' : 'ametysicon-folder249';
            }
        }
	],
	
	getFullPath: function()
	{
	    var separator = " > ";
	    var fullPath = this.getPath("text", separator);
	    var i = fullPath.indexOf(separator, 1);
	    return fullPath.substring(i + separator.length);
	}
});
