<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2014 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:filenameutils="org.apache.commons.io.FilenameUtils"
                xmlns:math="http://exslt.org/math"
                extension-element-prefixes="resolver filenameutils">

    <xsl:import href="common/files_3.3.xsl"/>

    <!-- Used in common.xsl -->
    <xsl:variable name="common-service-css-class-name">attachments server-directory small-icons</xsl:variable>

    <xsl:template name="FolderIcon">
        <img class="icon" style="vertical-align: middle" alt="">
            <xsl:attribute name="src"><xsl:value-of select="$uri-prefix"/>/plugins/web/resources/img/service/folder_<xsl:if test="not(node)">empty_</xsl:if>16.png</xsl:attribute>
        </img>
    </xsl:template>

    <xsl:template name="Icons">
            <img class="icon" alt=""><xsl:attribute name="src"><xsl:value-of select="$uri-prefix"/><xsl:text>/plugins/explorer/icon/</xsl:text><xsl:value-of select="filenameutils:getExtension(@name)"/><xsl:text>.png</xsl:text></xsl:attribute></img>
    </xsl:template>
</xsl:stylesheet>
