/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.serverdirectory;

import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.ametys.core.right.RightManager;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.URIUtils;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.data.holder.ModelAwareDataHolder;
import org.ametys.plugins.serverdirectory.ServerDirectoryHelper;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.ametys.runtime.authentication.AuthorizationRequiredException;
import org.ametys.web.repository.page.SitemapElement;
import org.ametys.web.repository.page.ZoneItem;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;

public class CheckPathAccessAction
extends ServiceableAction {
    private SourceResolver _srcResolver;
    private AmetysObjectResolver _resolver;
    private CurrentUserProvider _currentUserProvider;
    private RightManager _rightManager;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._srcResolver = (SourceResolver)smanager.lookup(SourceResolver.ROLE);
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
        this._currentUserProvider = (CurrentUserProvider)smanager.lookup(CurrentUserProvider.ROLE);
        this._rightManager = (RightManager)smanager.lookup(RightManager.ROLE);
    }

    public Map act(Redirector redirector, org.apache.cocoon.environment.SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Set<Source> rootSources;
        String language;
        String site;
        HashMap<String, String> result = new HashMap<String, String>();
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        String path = request.getParameter("path");
        String name = request.getParameter("name");
        if (StringUtils.isBlank((CharSequence)path)) {
            throw new IllegalArgumentException("Missing server directory's path");
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("Missing server file's name");
        }
        String decodedPath = ServerDirectoryHelper.normalize(URIUtils.decode((String)path));
        String zoneItemEncoded = parameters.getParameter("zoneItem");
        String zoneItemId = new String(Base64.getUrlDecoder().decode(zoneItemEncoded.getBytes("UTF-8")));
        ZoneItem zoneItem = (ZoneItem)this._resolver.resolveById(zoneItemId);
        this._checkPageAccess(zoneItem);
        ModelAwareDataHolder serviceParameters = zoneItem.getServiceParameters();
        boolean enableDynamicPaths = (Boolean)serviceParameters.getValue("enableDynamicPaths", false, (Object)false);
        Object folder = ServerDirectoryHelper.normalize((String)serviceParameters.getValue("folder"));
        if (enableDynamicPaths && !((String)(folder = ServerDirectoryHelper.evaluateDynamicPath((String)folder, site = (String)request.getAttribute("site"), language = (String)request.getAttribute("sitemapLanguage"), this._currentUserProvider.getUser()))).startsWith("file:/")) {
            folder = "file:/" + (String)folder;
        }
        if (!ServerDirectoryHelper.isValidPath(decodedPath, rootSources = ServerDirectoryHelper.getRootServerSources(this._srcResolver))) {
            throw new AccessDeniedException("You are not allowed to access to server directory file " + decodedPath);
        }
        if (!decodedPath.startsWith((String)folder)) {
            throw new IllegalStateException("The server directory file '" + decodedPath + "' is not part of the current service : " + (String)folder);
        }
        result.put("path", path);
        String decodedName = ServerDirectoryHelper.normalize(URIUtils.decode((String)name));
        Response response = ObjectModelHelper.getResponse((Map)objectModel);
        this._setHeader(decodedName, response);
        return result;
    }

    private void _checkPageAccess(ZoneItem zoneItem) throws AuthorizationRequiredException, AmetysRepositoryException, AccessDeniedException {
        SitemapElement sitemapElement = zoneItem.getZone().getSitemapElement();
        if (!this._rightManager.hasAnonymousReadAccess((Object)sitemapElement)) {
            UserIdentity user = this._currentUserProvider.getUser();
            if (user == null) {
                throw new AuthorizationRequiredException(null);
            }
            if (!this._rightManager.hasReadAccess(user, (Object)sitemapElement)) {
                throw new AccessDeniedException("Access to page " + sitemapElement.getSiteName() + "/" + sitemapElement.getSitemapName() + "/" + sitemapElement.getPathInSitemap() + " is not allowed for user " + user);
            }
        }
    }

    protected void _setHeader(String name, Response response) {
        String encodedName = URIUtils.encodeHeader((String)name);
        response.setHeader("Content-Disposition", "attachment; filename=\"" + encodedName + "\";filename*=UTF-8''" + encodedName);
    }
}

