/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.serverdirectory;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Base64;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.util.URIUtils;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.data.holder.ModelAwareDataHolder;
import org.ametys.plugins.serverdirectory.ServerDirectoryHelper;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.ametys.runtime.authentication.AuthorizationRequiredException;
import org.ametys.web.repository.page.ZoneItem;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.TraversableSource;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ServerDirectoryGenerator
extends ServiceableGenerator {
    protected SourceResolver _sourceResolver;
    protected CurrentUserProvider _currentUserProvider;

    public void service(ServiceManager smanager) throws ServiceException {
        this._sourceResolver = (SourceResolver)smanager.lookup(SourceResolver.ROLE);
        this._currentUserProvider = (CurrentUserProvider)smanager.lookup(CurrentUserProvider.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        ZoneItem zoneItem = (ZoneItem)request.getAttribute(ZoneItem.class.getName());
        ModelAwareDataHolder serviceParameters = zoneItem.getServiceParameters();
        String folder = ServerDirectoryHelper.normalize((String)serviceParameters.getValue("folder", false, (Object)""));
        try {
            Set<Source> rootSources;
            this.contentHandler.startDocument();
            if (((Boolean)serviceParameters.getValue("enableDynamicPaths", false, (Object)false)).booleanValue()) {
                folder = ServerDirectoryHelper.evaluateDynamicPath(folder, (String)request.getAttribute("site"), (String)request.getAttribute("sitemapLanguage"), this._currentUserProvider.getUser());
            }
            if (!ServerDirectoryHelper.isValidPath(folder, rootSources = ServerDirectoryHelper.getRootServerSources(this._sourceResolver))) {
                throw new IllegalStateException("The server directory '" + folder + "' is not an authorized directory");
            }
            Source sourceFolder = null;
            try {
                sourceFolder = this._sourceResolver.resolveURI(folder);
                if (!sourceFolder.exists()) {
                    throw new IllegalArgumentException("The server directory '" + folder + "' does not exist");
                }
                String zoneItemEncoded = new String(Base64.getUrlEncoder().encode(zoneItem.getId().getBytes("UTF-8")));
                Long depth = (Long)serviceParameters.getValue("depth");
                this.saxCollection(sourceFolder, zoneItemEncoded, depth == null || depth != (long)depth.intValue() ? Integer.MAX_VALUE : depth.intValue());
            }
            catch (URISyntaxException | AmetysRepositoryException | SourceException e) {
                throw new IllegalArgumentException("Cannot enumerate subdirectories for server location: <" + folder + ">", e);
            }
            finally {
                this._sourceResolver.release(sourceFolder);
            }
            this.contentHandler.endDocument();
        }
        catch (AccessDeniedException | AuthorizationRequiredException e) {
            throw new ProcessingException("No user is connected or the user has no required permissions to access to the server directory " + folder);
        }
    }

    protected void saxCollection(Source sourceFolder, String zoneItemId, Integer depth) throws SAXException, SourceException, URISyntaxException {
        if (sourceFolder instanceof TraversableSource) {
            TraversableSource tSource = (TraversableSource)sourceFolder;
            AttributesImpl childAtts = new AttributesImpl();
            childAtts.addCDATAAttribute("id", tSource.getURI());
            childAtts.addCDATAAttribute("name", tSource.getName());
            childAtts.addCDATAAttribute("encodedName", URIUtils.encodePathSegment((String)tSource.getName()));
            childAtts.addCDATAAttribute("mimetype", tSource.getMimeType());
            childAtts.addCDATAAttribute("lastModified", String.valueOf(tSource.getLastModified()));
            childAtts.addCDATAAttribute("size", String.valueOf(tSource.getContentLength()));
            childAtts.addCDATAAttribute("path", URIUtils.encodePath((String)tSource.getURI()));
            if (tSource.isCollection()) {
                childAtts.addCDATAAttribute("type", "collection");
                XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"Node", (Attributes)childAtts);
                if (depth > 0) {
                    Collection childrenSources = tSource.getChildren();
                    for (Source childSource : childrenSources) {
                        this.saxCollection(childSource, zoneItemId, depth - 1);
                    }
                }
                XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"Node");
            } else {
                childAtts.addCDATAAttribute("type", "resource");
                childAtts.addCDATAAttribute("zoneItem", zoneItemId);
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"Node", (Attributes)childAtts);
            }
        }
    }
}

