/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.serverdirectory;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ametys.core.user.UserIdentity;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.ametys.runtime.authentication.AuthorizationRequiredException;
import org.ametys.runtime.config.Config;
import org.apache.cocoon.ProcessingException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;

public final class ServerDirectoryHelper {
    private static final Pattern DYNAMIC_PATH_PATTERN = Pattern.compile("\\$\\{([^}\\[]+)(?:\\[([^=\\[\\]\\}\\{]+)=([^=\\[\\]\\}\\{]+)\\])?\\}");

    private ServerDirectoryHelper() {
    }

    public static Set<Source> getRootServerSources(SourceResolver sourceResolver) throws ProcessingException {
        Set<String> locations = ServerDirectoryHelper.getRootServerDirectoryPaths();
        HashSet<Source> sources = new HashSet<Source>();
        for (String location : locations) {
            Source src;
            block5: {
                src = null;
                try {
                    src = sourceResolver.resolveURI(location.trim(), "file://", null);
                    if (!src.exists()) break block5;
                    sources.add(src);
                }
                catch (Exception e) {
                    try {
                        throw new ProcessingException("Unable to retrieve server directory to location: <" + location + ">", (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        sourceResolver.release(src);
                        throw throwable;
                    }
                }
            }
            sourceResolver.release(src);
        }
        return sources;
    }

    public static Set<String> getRootServerDirectoryPaths() {
        String authorizedDirectories = (String)Config.getInstance().getValue("org.ametys.plugins.server.directory.authorized");
        String[] locations = StringUtils.split((String)authorizedDirectories, (String)"\n");
        Comparator<String> c = new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                int l1 = s1.length();
                int l2 = s2.length();
                return Integer.valueOf(l1).compareTo(l2);
            }
        };
        Arrays.sort(locations, c);
        HashSet<String> distinctLocations = new HashSet<String>();
        for (String location : locations) {
            boolean found = false;
            for (String distinctLocation : distinctLocations) {
                if (!location.startsWith(distinctLocation)) continue;
                found = true;
                break;
            }
            if (found) continue;
            distinctLocations.add(location.trim());
        }
        return distinctLocations;
    }

    public static String normalize(String path) {
        String normalizedPath = FilenameUtils.normalize((String)path);
        return normalizedPath.replace("\\", "/");
    }

    public static boolean isValidPath(String path, Set<Source> rootSources) {
        String normalizedPath = ServerDirectoryHelper.normalize(path);
        for (Source rootSource : rootSources) {
            if (!normalizedPath.startsWith(rootSource.getURI())) continue;
            return true;
        }
        return false;
    }

    public static String evaluateDynamicPath(String path, String siteName, String language, UserIdentity currentUser) throws AuthorizationRequiredException, AccessDeniedException, IllegalArgumentException {
        Matcher matcher = DYNAMIC_PATH_PATTERN.matcher(path);
        StringBuffer newPath = new StringBuffer();
        while (matcher.find()) {
            String variable = matcher.group(1);
            String param = matcher.group(2);
            String paramValue = matcher.group(3);
            if ("login".equals(variable)) {
                if (currentUser == null) {
                    throw new AuthorizationRequiredException(null);
                }
                if (param != null && paramValue != null) {
                    if ("population".equals(param)) {
                        Object[] populations = paramValue.split(",");
                        if (!ArrayUtils.contains((Object[])populations, (Object)currentUser.getPopulationId())) {
                            throw new AccessDeniedException("The user " + currentUser + " is not authorized to access file " + path);
                        }
                    } else {
                        throw new IllegalArgumentException("Unable to evaluate the current site");
                    }
                }
                matcher.appendReplacement(newPath, currentUser.getLogin());
                continue;
            }
            if ("population".equals(variable)) {
                if (currentUser == null) {
                    throw new AuthorizationRequiredException(null);
                }
                matcher.appendReplacement(newPath, currentUser.getPopulationId());
                continue;
            }
            if ("site".equals(variable)) {
                if (siteName == null) {
                    throw new IllegalArgumentException("Unable to evaluate the current site for service directory path " + path);
                }
                matcher.appendReplacement(newPath, siteName);
                continue;
            }
            if ("lang".equals(variable)) {
                if (language == null) {
                    throw new IllegalArgumentException("Unable to evaluate the current language for service directory path " + path);
                }
                matcher.appendReplacement(newPath, language);
                continue;
            }
            matcher.appendReplacement(newPath, "$0");
        }
        matcher.appendTail(newPath);
        return newPath.toString();
    }
}

