/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.serverdirectory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.plugins.serverdirectory.ServerDirectoryHelper;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.TraversableSource;

public class ServerDirectoryPathAction
extends ServiceableAction {
    private SourceResolver _sourceResolver;

    public void service(ServiceManager smanager) throws ServiceException {
        this._sourceResolver = (SourceResolver)smanager.lookup(SourceResolver.ROLE);
    }

    public Map act(Redirector redirector, org.apache.cocoon.environment.SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        HashMap result = new HashMap();
        ArrayList items = new ArrayList();
        boolean enableDynamicPaths = "true".equals(request.getParameter("enableDynamicPaths"));
        HashSet<Source> sources = new HashSet<Source>();
        String queryPath = ServerDirectoryHelper.normalize(parameters.getParameter("query", ""));
        Set<Source> rootSources = ServerDirectoryHelper.getRootServerSources(this._sourceResolver);
        for (Source rootSource : rootSources) {
            if (StringUtils.isEmpty((CharSequence)queryPath)) {
                sources.add(rootSource);
                continue;
            }
            String rootURI = rootSource.getURI();
            String rootPath = StringUtils.substringAfter((String)rootURI, (String)"file:/");
            if (queryPath.startsWith(rootPath) || queryPath.startsWith(rootURI)) {
                if (enableDynamicPaths) continue;
                sources.addAll(this._getValidServerDirectories(queryPath));
                continue;
            }
            if (!rootPath.startsWith(queryPath) && !rootURI.startsWith(queryPath)) continue;
            sources.add(rootSource);
        }
        for (Source pathResult : sources) {
            HashMap<String, String> item = new HashMap<String, String>();
            item.put("displayText", StringUtils.substringAfter((String)pathResult.getURI(), (String)(pathResult.getScheme() + ":/")));
            item.put("path", pathResult.getURI());
            items.add(item);
        }
        result.put("items", items);
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        return EMPTY_MAP;
    }

    private Set<Source> _getValidServerDirectories(String path) throws ProcessingException {
        HashSet<Source> validSources = new HashSet<Source>();
        String folderStartsWith = "";
        String rootPath = path.replace("\\", "/");
        if (!rootPath.endsWith("/")) {
            if (rootPath.contains("/")) {
                folderStartsWith = rootPath.substring(rootPath.lastIndexOf("/") + 1);
                rootPath = rootPath.substring(0, rootPath.lastIndexOf("/"));
            } else {
                folderStartsWith = rootPath;
                rootPath = "";
            }
        }
        Source root = null;
        try {
            root = this._sourceResolver.resolveURI(rootPath.trim(), "file://", null);
            if (root.exists() && root instanceof TraversableSource && ((TraversableSource)root).isCollection()) {
                if (folderStartsWith.isEmpty()) {
                    validSources.add(root);
                }
                TraversableSource tSource = (TraversableSource)root;
                Collection childrenSources = tSource.getChildren();
                for (Source childSource : childrenSources) {
                    String[] childPathSplit;
                    if (!(childSource instanceof TraversableSource) || !((TraversableSource)childSource).isCollection() || (childPathSplit = childSource.getURI().split("/")).length <= 0 || !childPathSplit[childPathSplit.length - 1].startsWith(folderStartsWith)) continue;
                    validSources.add(childSource);
                }
            }
        }
        catch (Exception e) {
            try {
                throw new ProcessingException("Unable to retrieve server directory to location: <" + rootPath + ">", (Throwable)e);
            }
            catch (Throwable throwable) {
                this._sourceResolver.release(root);
                throw throwable;
            }
        }
        this._sourceResolver.release(root);
        return validSources;
    }
}

