<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2014 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:filenameutils="org.apache.commons.io.FilenameUtils"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:math="http://exslt.org/math"
                xmlns:encoder="org.ametys.core.util.URIUtils"
                extension-element-prefixes="resolver filenameutils encoder ametys">

  	<xsl:import href="service:web://pages/services/common.xsl"/>

    <xsl:param name="header" select="string(ametys:serviceParameter('header')/text())"/>
    
    <!-- Used in common.xsl -->
    <xsl:variable name="is-empty" select="not(/Node)"/>    
    <xsl:variable name="common-service-name">service-explorer-folder</xsl:variable>  
    
    <xsl:variable name="id" select="concat('attachment_', substring-after(math:random(), '.'))"/>    

    <!-- +
         | HEAD
         + -->   
    <xsl:template name="common-service-head-title">
       	<xsl:call-template name="common-service-head-title-content">
            <xsl:with-param name="title" select="$header"/>                    
        </xsl:call-template>
    </xsl:template>
        
    
    <!-- +
     | BODY
     + -->    
     	
    <!-- Used in common.xsl -->         
    <xsl:template name="common-service-body-empty">
        <i18n:text i18n:key="ATTACHMENTS_NO_FILE"/>
    </xsl:template>     

    <!-- Used in common.xsl --> 
    <xsl:template name="common-service-body-nonempty-content-title">
  		<xsl:call-template name="common-service-body-nonempty-content-title-content">
            <xsl:with-param name="title" select="$header"/>
        </xsl:call-template>
    </xsl:template>

    <!-- Used in common.xsl --> 
    <xsl:template name="common-service-body-nonempty-content-content">
        <xsl:call-template name="attachment-list"/>
    </xsl:template>

    <xsl:template name="attachment-list">
        <ul id="{$id}" class="attachment-list">
            <xsl:apply-templates select="Node[@type = 'collection']">
                <xsl:sort select="@name"/>
            </xsl:apply-templates>
            
            <xsl:apply-templates select="Node[@type = 'resource']">
                <xsl:sort select="@name"/>
            </xsl:apply-templates>

        </ul>
    </xsl:template>

    <xsl:template match="Node[@type = 'collection' and parent::*]">
        <li>
            <xsl:call-template name="FolderIcon"/>
            
            <span class="folder"><xsl:value-of select="@name"/></span><br/>
            
            <xsl:if test="Node">
                <ul>
                    <xsl:apply-templates select="Node[@type = 'collection']">
                        <xsl:sort select="@name"/>
                    </xsl:apply-templates>
                    
                    <xsl:apply-templates select="Node[@type = 'resource']">
                        <xsl:sort select="@name"/>
                    </xsl:apply-templates>
                </ul>
            </xsl:if>
            
        </li>
    </xsl:template>

    <xsl:template match="Node[@type = 'resource']">
        <li>
            <span class="file">
                <a href="{$site-uri-prefix}/_plugins/server-directory/resources/{@zoneItem}/file?path={encoder:encodeParameter(@path)}&amp;name={encoder:encodeParameter(@encodedName)}" title="{@name} ({@size})">
					<xsl:call-template name="Icons"/>
                    <xsl:value-of select="@name"/>
                </a>
                <span class="size"><xsl:call-template name="format-size"><xsl:with-param name="size" select="@size"/></xsl:call-template></span>   
                <xsl:call-template name="DublinCore"/>         
            </span>        
        </li>
    </xsl:template>
    
    <xsl:template name="format-size">
        <xsl:param name="size"/>
        
        <xsl:choose>
            <xsl:when test="$size &lt; 1024">
                <i18n:translate>
                    <i18n:text i18n:key="ATTACHMENTS_FILE_SIZE_BYTES" i18n:catalogue="plugin.web"/>
                    <i18n:param><xsl:value-of select="$size"/></i18n:param>
                </i18n:translate>
            </xsl:when>
            <xsl:when test="$size &lt; (1024 * 1024)">
                <i18n:translate>
                    <i18n:text i18n:key="ATTACHMENTS_FILE_SIZE_KB" i18n:catalogue="plugin.web"/>
                    <i18n:param><xsl:value-of select="round($size div 1024)"/></i18n:param>
                </i18n:translate>
            </xsl:when>
            <xsl:otherwise>
                <i18n:translate>
                    <i18n:text i18n:key="ATTACHMENTS_FILE_SIZE_MB" i18n:catalogue="plugin.web"/>
                    <i18n:param><xsl:value-of select="round($size div (1024 * 1024))"/></i18n:param>
                </i18n:translate>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="DublinCore"/>

</xsl:stylesheet>
