/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.skincommons;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.util.DateUtils;
import org.ametys.core.util.path.PathUtils;
import org.ametys.plugins.repository.AmetysObjectIterator;
import org.ametys.plugins.skincommons.SkinEditionHelper;
import org.ametys.plugins.skincommons.SkinLockManager;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.ametys.web.repository.sitemap.Sitemap;
import org.ametys.web.skin.Skin;
import org.ametys.web.skin.SkinsManager;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractCommonSkinDAO
extends AbstractLogEnabled
implements Serviceable,
Component {
    private static final String __TEMP_MODE = "temp";
    private static final String __WORK_MODE = "work";
    protected SiteManager _siteManager;
    protected SkinEditionHelper _skinHelper;
    protected SkinLockManager _lockManager;
    protected CurrentUserProvider _userProvider;
    protected UserManager _userManager;
    protected SkinsManager _skinsManager;

    public void service(ServiceManager smanager) throws ServiceException {
        this._siteManager = (SiteManager)smanager.lookup(SiteManager.ROLE);
        this._skinsManager = (SkinsManager)smanager.lookup(SkinsManager.ROLE);
        this._skinHelper = (SkinEditionHelper)((Object)smanager.lookup(SkinEditionHelper.ROLE));
        this._lockManager = (SkinLockManager)((Object)smanager.lookup(SkinLockManager.ROLE));
        this._userProvider = (CurrentUserProvider)smanager.lookup(CurrentUserProvider.ROLE);
        this._userManager = (UserManager)smanager.lookup(UserManager.ROLE);
    }

    @Callable(rights={"*"})
    public String getPreviewURI(String siteName, String lang) {
        String siteLangage;
        Site site = this._siteManager.getSite(siteName);
        String string = siteLangage = !StringUtils.isEmpty((CharSequence)lang) ? lang : ((Sitemap)site.getSitemaps().iterator().next()).getName();
        if (site.getSitemap(siteLangage).hasChild("index")) {
            return siteLangage + "/index.html";
        }
        AmetysObjectIterator it = site.getSitemap(siteLangage).getChildrenPages().iterator();
        if (it.hasNext()) {
            String path = ((Page)it.next()).getPathInSitemap();
            return siteLangage + "/" + path + ".html";
        }
        return null;
    }

    @Callable(rights={""})
    public Map<String, Object> checkUnsaveModifications(String skinName) throws IOException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        this.checkUserRight(skinName);
        Path tempDir = this._skinHelper.getTempDirectory(skinName);
        Path workDir = this._skinHelper.getWorkDirectory(skinName);
        Path skinDir = this._skinHelper.getSkinDirectory(skinName);
        if (!this._lockManager.canWrite(tempDir)) {
            return result;
        }
        long lastModifiedLock = this._lockManager.lastModified(tempDir).getTime();
        if (lastModifiedLock <= Files.getLastModifiedTime(workDir, new LinkOption[0]).toMillis()) {
            if (Files.getLastModifiedTime(workDir, new LinkOption[0]).toMillis() > Files.getLastModifiedTime(skinDir, new LinkOption[0]).toMillis()) {
                result.put("hasUncommitChanges", true);
            } else {
                PathUtils.deleteDirectory((Path)workDir);
            }
        } else if (lastModifiedLock >= Files.getLastModifiedTime(skinDir, new LinkOption[0]).toMillis()) {
            result.put("hasUnsaveChanges", true);
        }
        return result;
    }

    @Callable(rights={""})
    public Map<String, Object> saveChanges(String skinName, boolean quit) throws IOException {
        this.checkUserRight(skinName);
        Map<String, Object> lockInfos = this._checkLock(skinName);
        if (!lockInfos.isEmpty()) {
            return lockInfos;
        }
        Path tempDir = this._skinHelper.getTempDirectory(skinName);
        Path workDir = this._skinHelper.getWorkDirectory(skinName);
        if (Files.exists(workDir, new LinkOption[0])) {
            this._skinHelper.deleteQuicklyDirectory(workDir);
        }
        if (quit) {
            PathUtils.moveDirectory((Path)tempDir, (Path)workDir);
            PathUtils.deleteQuietly((Path)workDir.resolve(".lock"));
        } else {
            PathUtils.copyDirectory((Path)tempDir, (Path)workDir, file -> !file.getFileName().toString().equals(".lock"), (boolean)false);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("skinName", skinName);
        return result;
    }

    protected abstract void checkUserRight(String var1);

    @Callable(rights={""})
    public Map<String, Object> commitChanges(String skinName, boolean quit) throws Exception {
        this.checkUserRight(skinName);
        Skin skin = this._skinsManager.getSkin(skinName);
        if (!skin.isModifiable()) {
            throw new IllegalStateException("The skin '" + skinName + "' is not modifiable and thus cannot be modified.");
        }
        Map<String, Object> lockInfos = this._checkLock(skinName);
        if (!lockInfos.isEmpty()) {
            return lockInfos;
        }
        Path skinDir = this._skinHelper.getSkinDirectory(skinName);
        Path backupDir = this._skinHelper.createBackupFile(skinName);
        Path tempDir = this._skinHelper.getTempDirectory(skinName);
        PathUtils.moveDirectory((Path)tempDir, (Path)skinDir);
        Path workDir = this._skinHelper.getWorkDirectory(skinName);
        if (quit) {
            this._skinHelper.deleteQuicklyDirectory(workDir);
        } else {
            PathUtils.copyDirectory((Path)skinDir, (Path)workDir, file -> !file.getFileName().toString().equals(".lock"), (boolean)true);
            PathUtils.copyDirectory((Path)skinDir, (Path)tempDir, (boolean)true);
        }
        PathUtils.deleteQuietly((Path)skinDir.resolve(".lock"));
        this._skinHelper.invalidateCaches(skinName);
        this._skinHelper.invalidateSkinCatalogues(skinName);
        this._skinHelper.deleteOldBackup(skinName, 5);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("backupFilename", backupDir.getFileName().toString());
        String mailSysAdmin = (String)Config.getInstance().getValue("smtp.mail.sysadminto");
        if (!mailSysAdmin.isEmpty()) {
            result.put("adminEmail", mailSysAdmin);
        }
        return result;
    }

    @Callable(rights={""})
    public Map<String, Object> cancelChanges(String skinName, boolean workVersion, String toolId) throws IOException {
        this.checkUserRight(skinName);
        Map<String, Object> lockInfos = this._checkLock(skinName);
        if (!lockInfos.isEmpty()) {
            return lockInfos;
        }
        String modelBeforeCancel = this._skinHelper.getTempModel(skinName);
        Path tempDir = this._skinHelper.getTempDirectory(skinName);
        if (Files.exists(tempDir, new LinkOption[0])) {
            this._skinHelper.deleteQuicklyDirectory(tempDir);
        }
        Path workDir = this._skinHelper.getWorkDirectory(skinName);
        if (workVersion && Files.exists(workDir, new LinkOption[0])) {
            PathUtils.copyDirectory((Path)workDir, (Path)tempDir);
        } else {
            if (Files.exists(workDir, new LinkOption[0])) {
                this._skinHelper.deleteQuicklyDirectory(workDir);
            }
            Path skinDir = this._skinHelper.getSkinDirectory(skinName);
            PathUtils.copyDirectory((Path)skinDir, (Path)tempDir);
        }
        String modelAfterCancel = this._skinHelper.getTempModel(skinName);
        this._lockManager.updateLockFile(tempDir, !toolId.isEmpty() ? toolId : "uitool-skineditor");
        this._skinHelper.invalidateTempSkinCatalogues(skinName);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("hasChanges", modelAfterCancel == null || !modelAfterCancel.equals(modelBeforeCancel));
        return result;
    }

    private Map<String, Object> _checkLock(String skinName) throws IOException {
        Path tempDir = this._skinHelper.getTempDirectory(skinName);
        if (!this._lockManager.canWrite(tempDir)) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            UserIdentity lockOwner = this._lockManager.getLockOwner(tempDir);
            User user = this._userManager.getUser(lockOwner.getPopulationId(), lockOwner.getLogin());
            result.put("isLocked", true);
            result.put("lockOwner", user != null ? user.getFullName() + " (" + String.valueOf(lockOwner) + ")" : lockOwner);
            result.put("success", false);
            return result;
        }
        return Collections.EMPTY_MAP;
    }

    @Callable(rights={"*"})
    public String getSkinModel(String siteName, String skinName, String mode) {
        String skinId = this._getSkinName(siteName, skinName);
        if (__TEMP_MODE.equals(mode)) {
            return this._skinHelper.getTempModel(skinId);
        }
        if (__WORK_MODE.equals(mode)) {
            return this._skinHelper.getWorkModel(skinId);
        }
        return this._skinHelper.getSkinModel(skinId);
    }

    private String _getSkinName(String siteName, String skinName) {
        if (StringUtils.isEmpty((CharSequence)skinName) && StringUtils.isNotEmpty((CharSequence)siteName)) {
            Site site = this._siteManager.getSite(siteName);
            return site.getSkinId();
        }
        return skinName;
    }

    @Callable(rights={""})
    public Map<String, Object> getLock(String siteName, String skinName) throws IOException {
        String skinId = this._getSkinName(siteName, skinName);
        this.checkUserRight(skinId);
        HashMap<String, Object> result = new HashMap<String, Object>();
        Path tempDir = this._skinHelper.getTempDirectory(skinId);
        if (Files.exists(tempDir, new LinkOption[0]) && this._lockManager.isLocked(tempDir)) {
            UserIdentity lockOwner = this._lockManager.getLockOwner(tempDir);
            User user = this._userManager.getUser(lockOwner.getPopulationId(), lockOwner.getLogin());
            result.put("isLocked", !this._userProvider.getUser().equals((Object)lockOwner));
            result.put("lockOwner", user != null ? user.getFullName() + " (" + String.valueOf(lockOwner) + ")" : lockOwner);
            result.put("lastModified", DateUtils.dateToString((Date)this._lockManager.lastModified(tempDir)));
            result.put("toolId", this._lockManager.getLockTool(tempDir));
        } else {
            result.put("isLocked", false);
        }
        Path workDir = this._skinHelper.getWorkDirectory(skinId);
        if (Files.exists(workDir, new LinkOption[0])) {
            result.put("lastSave", DateUtils.dateToString((Date)new Date(Files.getLastModifiedTime(workDir, new LinkOption[0]).toMillis())));
        }
        return result;
    }

    @Callable(rights={""})
    public Map<String, Object> clearModifications(String skinName, boolean workVersion) throws IOException {
        Path workDir;
        this.checkUserRight(skinName);
        Map<String, Object> lockInfos = this._checkLock(skinName);
        if (!lockInfos.isEmpty()) {
            return lockInfos;
        }
        Path tempDir = this._skinHelper.getTempDirectory(skinName);
        if (Files.exists(tempDir, new LinkOption[0])) {
            this._skinHelper.deleteQuicklyDirectory(tempDir);
        }
        if (workVersion && Files.exists(workDir = this._skinHelper.getWorkDirectory(skinName), new LinkOption[0])) {
            this._skinHelper.deleteQuicklyDirectory(workDir);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("skinName", skinName);
        return result;
    }
}

