/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.skineditor.readers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.ametys.core.util.ImageHelper;
import org.ametys.core.util.URIUtils;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.reading.ServiceableReader;
import org.apache.commons.io.IOUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.impl.FileSource;
import org.xml.sax.SAXException;

public class SkinResourceReader
extends ServiceableReader {
    protected SourceResolver _srcResolver;
    protected FileSource _file;
    private boolean _readForDownload;
    private int _width;
    private int _height;
    private int _maxWidth;
    private int _maxHeight;
    private Collection<String> _allowedFormats = Arrays.asList("png", "gif", "jpg", "jpeg");

    public void service(ServiceManager smanager) throws ServiceException {
        this._srcResolver = (SourceResolver)smanager.lookup(SourceResolver.ROLE);
    }

    public void setup(org.apache.cocoon.environment.SourceResolver res, Map objModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(res, objModel, src, par);
        String skin = par.getParameter("skin", null);
        String path = par.getParameter("path", null);
        assert (skin != null || path != null);
        this._readForDownload = par.getParameterAsBoolean("download", false);
        this._width = par.getParameterAsInteger("width", 0);
        this._height = par.getParameterAsInteger("height", 0);
        this._maxWidth = par.getParameterAsInteger("maxWidth", 0);
        this._maxHeight = par.getParameterAsInteger("maxHeight", 0);
        this._file = (FileSource)this._getSource(skin, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate() throws IOException, SAXException, ProcessingException {
        try (InputStream is = this._file.getInputStream();){
            String name = this._file.getName();
            name = name.replaceAll("\\\\", "\\\\\\\\");
            name = name.replaceAll("\\\"", "\\\\\\\"");
            Response response = ObjectModelHelper.getResponse((Map)this.objectModel);
            if (this._readForDownload) {
                response.setHeader("Content-Disposition", "attachment; filename=\"" + name + "\"");
            }
            if (this._width > 0 || this._height > 0 || this._maxHeight > 0 || this._maxWidth > 0) {
                int i = name.lastIndexOf(46);
                String format = i != -1 ? name.substring(i + 1) : "png";
                format = this._allowedFormats.contains(format) ? format : "png";
                ImageHelper.generateThumbnail((InputStream)is, (OutputStream)this.out, (String)format, (int)this._height, (int)this._width, (int)this._maxHeight, (int)this._maxWidth);
            } else {
                response.setHeader("Content-Length", Long.toString(this._file.getContentLength()));
                IOUtils.copy((InputStream)is, (OutputStream)this.out);
            }
        }
        finally {
            IOUtils.closeQuietly((OutputStream)this.out);
        }
    }

    private Source _getSource(String skinName, String path) throws IOException {
        Object decodedPath = URIUtils.decode((String)path);
        decodedPath = ((String)decodedPath).startsWith("/") ? decodedPath : "/" + (String)decodedPath;
        return this._srcResolver.resolveURI("ametys-home://skins/temp/" + skinName + (String)decodedPath);
    }
}

