/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.skineditor.skin;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.ametys.core.right.RightManager;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.path.PathUtils;
import org.ametys.plugins.skincommons.AbstractCommonSkinDAO;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.skin.Skin;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class SkinDAO
extends AbstractCommonSkinDAO {
    public static final String ROLE = SkinDAO.class.getName();
    public static final String EDIT_SKINS_RIGHT_ID = "Plugins_SkinEditor_EditAllSkin";
    public static final String EDIT_CURRENT_SKIN_RIGHT_ID = "Plugins_SkinEditor_EditCurrentSkin";
    public static final String SKIN_EDITOR_TOOL_ID = "uitool-skineditor";
    private static final String __WORK_MODE = "work";
    private static final String __PROD_MODE = "prod";
    private RightManager _rightManager;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._rightManager = (RightManager)manager.lookup(RightManager.ROLE);
    }

    protected void checkUserRight(String skinName) {
        UserIdentity user = this._userProvider.getUser();
        if (!(this._rightManager.hasRight(user, EDIT_SKINS_RIGHT_ID, (Object)"/${WorkspaceName}") == RightManager.RightResult.RIGHT_ALLOW || this._skinsManager.getSkinNameFromRequest().equals(skinName) && this._rightManager.hasRight(user, EDIT_CURRENT_SKIN_RIGHT_ID, (Object)"/${WorkspaceName}") == RightManager.RightResult.RIGHT_ALLOW)) {
            throw new AccessDeniedException("User '" + String.valueOf(user) + "' tried perform operation on skin '" + skinName + "' without sufficient right");
        }
    }

    @Callable(rights={""})
    public List<Object> getSkinsList() {
        HashSet<String> skins = new HashSet<String>();
        String currentSkinId = this._skinsManager.getSkinNameFromRequest();
        UserIdentity user = this._userProvider.getUser();
        if (this._rightManager.hasRight(user, EDIT_SKINS_RIGHT_ID, (Object)"/${WorkspaceName}") == RightManager.RightResult.RIGHT_ALLOW) {
            skins.addAll(this._skinsManager.getSkins());
        } else if (this._rightManager.hasRight(user, EDIT_CURRENT_SKIN_RIGHT_ID, (Object)"/${WorkspaceName}") == RightManager.RightResult.RIGHT_ALLOW) {
            skins.add(currentSkinId);
        }
        return skins.stream().map(id -> this._skinsManager.getSkin(id)).filter(Skin::isModifiable).filter(Predicate.not(Skin::isAbstract)).map(s -> this._skin2JsonObject((Skin)s, s.getId().equals(currentSkinId))).collect(Collectors.toList());
    }

    private Map<String, Object> _skin2JsonObject(Skin skin, boolean current) {
        HashMap<String, Object> jsonObject = new HashMap<String, Object>();
        I18nizableText label = skin.getLabel();
        String icon = skin.getLargeImage();
        jsonObject.put("id", skin.getId());
        jsonObject.put("current", current);
        jsonObject.put("label", label);
        jsonObject.put("icon", icon);
        return jsonObject;
    }

    @Callable(rights={""})
    public String openSkin(String skinId, String mode, boolean unlinkModel) throws Exception {
        this.checkUserRight(skinId);
        Skin skin = this._skinsManager.getSkin(skinId);
        if (!skin.isModifiable()) {
            throw new IllegalStateException("The skin '" + skinId + "' is not modifiable and thus cannot be opened in skin editor.");
        }
        Path tempDir = this._skinHelper.getTempDirectory(skinId);
        Path workDir = this._skinHelper.getWorkDirectory(skinId);
        Path skinDir = this._skinHelper.getSkinDirectory(skinId);
        if (unlinkModel) {
            this.unlinkModel(skinDir);
            this.unlinkModel(workDir);
            this.unlinkModel(tempDir);
        }
        if (__PROD_MODE.equals(mode) || __WORK_MODE.equals(mode)) {
            if (Files.exists(tempDir, new LinkOption[0])) {
                this._skinHelper.deleteQuicklyDirectory(tempDir);
            }
            if (__PROD_MODE.equals(mode)) {
                if (Files.exists(workDir, new LinkOption[0])) {
                    this._skinHelper.deleteQuicklyDirectory(workDir);
                }
                PathUtils.copyDirectory((Path)skinDir, (Path)workDir);
            }
            PathUtils.copyDirectory((Path)workDir, (Path)tempDir);
            this._lockManager.updateLockFile(tempDir, SKIN_EDITOR_TOOL_ID);
        } else {
            this._lockManager.updateLockFile(tempDir, SKIN_EDITOR_TOOL_ID);
        }
        return skinId;
    }

    protected void unlinkModel(Path skinDir) throws IOException {
        Path modelFile = skinDir.resolve("model.xml");
        Path bakFile = skinDir.resolve("model.xml.bak");
        if (Files.exists(bakFile, new LinkOption[0])) {
            PathUtils.deleteQuietly((Path)bakFile);
        }
        if (Files.exists(modelFile, new LinkOption[0])) {
            Files.move(modelFile, bakFile, new CopyOption[0]);
        }
    }
}

