/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * Tool showing the code editor.
 * @private
 */
Ext.define('Ametys.plugins.skineditor.EditorTool',
{
    extend: 'Ametys.file.AbstractFileEditorTool',

    getMessageTargetConfiguration: function ()
	{
		return {
			id: Ametys.message.MessageTarget.SKIN_RESOURCE,
   	        parameters: {
   	        	'name': this.getFileName(), 
   	        	'path': this.getFilePath(),
   	        	'skinName': this.getSkinName()
   	        }
   	    }
	},
	
	getMessageTargetIdForResource: function ()
	{
		return Ametys.message.MessageTarget.SKIN_RESOURCE;
	},
	
	getMessageTargetIdForCollection: function ()
	{
		return Ametys.message.MessageTarget.SKIN_COLLECTION;
	},
	
	reloadFile: function ()
	{
		this.showRefreshing();
		this.setLoaded(false);
		
		Ametys.data.ServerComm.send({
            plugin: 'skineditor',
            url: "file/read",
            parameters: {
                path: this.getFilePath(),
                skinName: this.getSkinName()
            },
            priority: Ametys.data.ServerComm.PRIORITY_MAJOR,
            callback: {
                handler: this._loadFileCb,
                scope: this
            },
            errorMessage: true,
            waitMessage: true,
            responseType: "text"
        });
	},
	
	/**
	 * Callback function after {@link #reloadFile} is processed. Fills the {@link #_editor} with the file content.
	 * @param {Object} response The text response provided by the {@link Ametys.data.ServerComm}
	 * @param {Object} args The callback parameters passed to the {@link Ametys.data.ServerComm#send} method
    */
	_loadFileCb: function(response, args)
	{
		if (!Ametys.data.ServerComm.isBadResponse(response))
		{
			this.setText(Ext.dom.Query.selectValue("", response, ""));   	
			this.setLoaded(true);
			this.setDirty(false);
		}      
      
		this.showRefreshed();
	},
	
    /**
     * Initialize the tool with parameters
     * @param {Object} params The parameters
     */
    setParams: function (params)
    {
    	this._skinName = params.skinName;
    	this.callParent(arguments);
    },

    /**
     * Getter for the skin name
     * @return {String} The skin name
     */
    getSkinName: function()
    {
        return this._skinName;
    }

});
