/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.skineditor.clientsideelement;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ametys.core.right.RightManager;
import org.ametys.core.ui.ClientSideElement;
import org.ametys.core.ui.StaticClientSideElement;
import org.ametys.core.user.UserIdentity;
import org.ametys.web.skin.Skin;
import org.ametys.web.skin.SkinsManager;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class OpenSkinEditorClientSideElement
extends StaticClientSideElement {
    private SkinsManager _skinManager;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._skinManager = (SkinsManager)smanager.lookup(SkinsManager.ROLE);
    }

    public List<ClientSideElement.Script> getScripts(boolean ignoreRights, Map<String, Object> contextParameters) {
        if (!this._hasModifiableSkin()) {
            return Collections.EMPTY_LIST;
        }
        return super.getScripts(ignoreRights, contextParameters);
    }

    private boolean _hasModifiableSkin() {
        UserIdentity user = this._currentUserProvider.getUser();
        if (this._rightManager.hasRight(user, "Plugins_SkinEditor_EditAllSkin", (Object)"/${WorkspaceName}") == RightManager.RightResult.RIGHT_ALLOW) {
            return !this._skinManager.getSkins().stream().map(id -> this._skinManager.getSkin(id)).filter(Skin::isModifiable).collect(Collectors.toList()).isEmpty();
        }
        if (this._rightManager.hasRight(user, "Plugins_SkinEditor_EditCurrentSkin", (Object)"/${WorkspaceName}") == RightManager.RightResult.RIGHT_ALLOW) {
            String currentSkinName = this._skinManager.getSkinNameFromRequest();
            return this._skinManager.getSkin(currentSkinName).isModifiable();
        }
        return false;
    }
}

