/*
 *  Copyright 2013 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class controls a ribbon button that will be enable only if there is a content store into the clipboard.
 * @private
 */
Ext.define('Ametys.plugins.skineditor.controller.PasteSkinController', {
	extend: 'Ametys.ribbon.element.ui.ButtonController',
	
	/**
	 * Constructor for the paste skin controller
	 */
	constructor: function()
	{
		this.callParent(arguments);
		
		this.disable();
		this.setDescription(this.getInitialConfig("nocopiedcontent-description"));
		
		Ametys.message.MessageBus.on(Ametys.message.Message.MODIFIED, this._onModified, this);
	},
	
	/**
	 * Listener when the clipboard has been modified.
	 * Enable/disable the buttons.
	 * @param {Ametys.message.Message} message The modified message.
	 * @protected
	 */
	_onModified: function (message)
	{
		message = message || Ametys.message.MessageBus.getCurrentSelectionMessage();
		
		var clipboardTarget = message.getTarget(Ametys.message.MessageTarget.CLIPBOARD); 
		
		if (clipboardTarget != null)
		{
			if (Ametys.clipboard.Clipboard.getData().length > 0 && (Ametys.clipboard.Clipboard.getType() == "skin-resource" || Ametys.clipboard.Clipboard.getType() == "skin-collection"))
			{
				this.setDescription(this.getInitialConfig("description"));
				this.enable();
			}
			else
			{
				this.setDescription(this.getInitialConfig("nocopiedcontent-description"));
				this.disable();
			}
			
		}
	}
});

