/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.skinfactory.parameters;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.skinfactory.parameters.AbstractSkinParameter;
import org.ametys.skinfactory.parameters.SkinParameterException;
import org.ametys.web.skin.SkinModel;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.io.IOUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class I18nizableTextParameter
extends AbstractSkinParameter {
    private String _i18nKey;
    private Map<String, String> _defaultValues;

    public I18nizableTextParameter(String id, I18nizableText label, I18nizableText description, String i18nKey, Map<String, String> defaultValues) {
        super(id, label, description);
        this._i18nKey = i18nKey;
        this._defaultValues = defaultValues;
    }

    @Override
    public AbstractSkinParameter.SkinParameterType getType() {
        return AbstractSkinParameter.SkinParameterType.I18N;
    }

    public String geti18nKey() {
        return this._i18nKey;
    }

    public void setKey(String i18nKey) {
        this._i18nKey = i18nKey;
    }

    @Override
    public void apply(Path tempDir, Path modelDir, Object value, String lang) {
        Path f;
        Path i18nFile = tempDir.resolve("i18n/messages.xml");
        if (lang != null && Files.exists(f = tempDir.resolve("i18n/messages_" + lang + ".xml"), new LinkOption[0])) {
            i18nFile = f;
        }
        String string = this._filetoString(i18nFile);
        Pattern pattern = null;
        pattern = i18nFile.getFileName().toString().equals("messages.xml") ? Pattern.compile("^\\s*<message key=\"" + this.geti18nKey() + "\">([^<]*)<!--\\s*AMETYS\\s*\\(\\s*\"([^\"]+)\"\\s*(?:,\\s*([^,\"\\s]+|\"[^\"]*\")\\s*)?(?:,\\s*([^,\"\\s]+|\"[^\"]*\")\\s*)?\\)\\s*--></message>\\s*$", 8) : Pattern.compile("^\\s*<message key=\"" + this.geti18nKey() + "\">([^<]*)</message>\\s*$", 8);
        Matcher matcher = pattern.matcher(string);
        try (OutputStream os = Files.newOutputStream(i18nFile, new OpenOption[0]);){
            int startIndex = 0;
            while (matcher.find()) {
                int propertyStart = matcher.start(1);
                String beforeValue = string.substring(startIndex, propertyStart);
                IOUtils.write((String)beforeValue, (OutputStream)os, (String)"UTF-8");
                IOUtils.write((String)((String)value), (OutputStream)os, (String)"UTF-8");
                startIndex = matcher.end(1);
            }
            IOUtils.write((String)string.substring(startIndex), (OutputStream)os, (String)"UTF-8");
        }
        catch (IOException e) {
            throw new SkinParameterException("Unable to apply css parameter '" + this.getId() + "'", e);
        }
    }

    private String _filetoString(Path file) {
        try {
            return Files.readString(file, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new SkinParameterException("Unable to parse file '" + file.getFileName().toString() + "'", e);
        }
    }

    @Override
    public void toSAX(ContentHandler contentHandler, String modelName) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("id", this.getId());
        attrs.addCDATAAttribute("type", AbstractSkinParameter.SkinParameterType.I18N.name().toLowerCase());
        XMLUtils.startElement((ContentHandler)contentHandler, (String)"parameter", (Attributes)attrs);
        this.getLabel().toSAX(contentHandler, "label");
        this.getDescription().toSAX(contentHandler, "description");
        XMLUtils.createElement((ContentHandler)contentHandler, (String)"i18nkey", (String)this.geti18nKey());
        XMLUtils.endElement((ContentHandler)contentHandler, (String)"parameter");
    }

    @Override
    public Map<String, Object> toJson(String modelName) {
        HashMap<String, Object> jsonObject = new HashMap<String, Object>();
        jsonObject.put("id", this.getId());
        jsonObject.put("type", AbstractSkinParameter.SkinParameterType.I18N.name().toLowerCase());
        jsonObject.put("label", this.getLabel());
        jsonObject.put("description", this.getDescription());
        jsonObject.put("i18nkey", this.geti18nKey());
        return jsonObject;
    }

    public Map<String, String> getDefaultValues() {
        return this._defaultValues;
    }

    @Override
    public String getDefaultValue(SkinModel model) {
        return this.getDefaultValue(model, null);
    }

    @Override
    public String getDefaultValue(SkinModel model, String lang) {
        if (lang != null && this._defaultValues.containsKey(lang)) {
            return this._defaultValues.get(lang);
        }
        return this._defaultValues.entrySet().iterator().next().getValue();
    }
}

