/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.skinfactory.parameters;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.skinfactory.parameters.AbstractSkinParameter;
import org.ametys.skinfactory.parameters.SkinParameterException;
import org.ametys.web.skin.SkinModel;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.io.IOUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class TextParameter
extends AbstractSkinParameter {
    private String _defaultValue;
    private Path _xslFile;

    public TextParameter(String id, I18nizableText label, I18nizableText description, Path xslFile, String defaultValue) {
        super(id, label, description);
        this._xslFile = xslFile;
        this._defaultValue = defaultValue;
    }

    public Path getPath() {
        return this._xslFile;
    }

    @Override
    public AbstractSkinParameter.SkinParameterType getType() {
        return AbstractSkinParameter.SkinParameterType.TEXT;
    }

    @Override
    public void apply(Path tempDir, Path modelDir, Object value, String lang) {
        String relPath = modelDir.relativize(this._xslFile).toString();
        Path cssFile = tempDir.resolve(relPath);
        String string = this._filetoString(cssFile);
        Pattern pattern = Pattern.compile("^[^>]*>([^<]*)<!--\\s*AMETYS\\s*\\(\\s*\"([^\"]+)\"\\s*(?:,\\s*([^,\"\\s]+|\"[^\"]*\")\\s*)?(?:,\\s*([^,\"\\s]+|\"[^\"]*\")\\s*)?\\)\\s*-->.*$$", 8);
        Matcher matcher = pattern.matcher(string);
        try (OutputStream os = Files.newOutputStream(cssFile, new OpenOption[0]);){
            int startIndex = 0;
            while (matcher.find()) {
                int propertyStart = matcher.start(1);
                String beforeValue = string.substring(startIndex, propertyStart);
                IOUtils.write((String)beforeValue, (OutputStream)os, (String)"UTF-8");
                IOUtils.write((String)((String)value), (OutputStream)os, (String)"UTF-8");
                startIndex = matcher.end(1);
            }
            IOUtils.write((String)string.substring(startIndex), (OutputStream)os, (String)"UTF-8");
        }
        catch (IOException e) {
            throw new SkinParameterException("Unable to apply text parameter '" + this.getId() + "'", e);
        }
    }

    private String _filetoString(Path file) {
        try {
            return Files.readString(file, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new SkinParameterException("Unable to parse file '" + file.getFileName().toString() + "'", e);
        }
    }

    @Override
    public void toSAX(ContentHandler contentHandler, String modelName) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("id", this.getId());
        attrs.addCDATAAttribute("type", AbstractSkinParameter.SkinParameterType.TEXT.name().toLowerCase());
        XMLUtils.startElement((ContentHandler)contentHandler, (String)"parameter", (Attributes)attrs);
        this.getLabel().toSAX(contentHandler, "label");
        this.getDescription().toSAX(contentHandler, "description");
        XMLUtils.endElement((ContentHandler)contentHandler, (String)"parameter");
    }

    @Override
    public Map<String, Object> toJson(String modelName) {
        HashMap<String, Object> jsonObject = new HashMap<String, Object>();
        jsonObject.put("id", this.getId());
        jsonObject.put("type", AbstractSkinParameter.SkinParameterType.TEXT.name().toLowerCase());
        jsonObject.put("label", this.getLabel());
        jsonObject.put("description", this.getDescription());
        return jsonObject;
    }

    @Override
    public String getDefaultValue(SkinModel model) {
        return this._defaultValue;
    }

    @Override
    public String getDefaultValue(SkinModel model, String lang) {
        return this.getDefaultValue(model);
    }
}

