/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.skinfactory.skins;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.web.skin.actions.UploadSkinAction;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.servlet.multipart.Part;
import org.apache.cocoon.servlet.multipart.PartOnDisk;
import org.apache.cocoon.servlet.multipart.RejectedPart;

public class UploadModelAction
extends UploadSkinAction {
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        try {
            Part part = (Part)request.get("importfile");
            if (part instanceof RejectedPart || part == null) {
                result.put("success", false);
                result.put("error", "rejected");
            } else {
                PartOnDisk uploadedFilePart = (PartOnDisk)part;
                File uploadedFile = uploadedFilePart.getFile();
                String filename = (String)uploadedFilePart.getHeaders().get("filename");
                String modelName = filename.substring(0, filename.length() - 4);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Uploading model" + modelName);
                }
                File dir = this._unzip(uploadedFile);
                this._filter(dir, dir.getAbsolutePath(), true);
                result.put("skinDir", dir.getName());
                result.put("tempDir", dir.getParentFile().getName());
                result.put("skinName", modelName);
                result.put("success", "true");
            }
        }
        catch (Exception e) {
            this.getLogger().error("Unable to add model", (Throwable)e);
            result.put("success", false);
            HashMap<String, String> ex = new HashMap<String, String>();
            ex.put("message", e.getMessage());
            result.put("error", ex);
        }
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        return result;
    }
}

