/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This factory creates Ametys.message.MessageTarget for a skin model.
 * 
 * See #createTargets to know more.
 * @private
 */
Ext.define("Ametys.plugins.skinfactory.model.SkinModelMessageTargetFactory",
{
    extend: "Ametys.message.factory.DefaultMessageTargetFactory",

    /**
     * Create the targets for a message
     * @param {Object} parameters The parameters needed by the factory to create the message. Can not be null. Handled elements are
     * @param {String[]} parameters.id The model's identifier.
     * @param {Function} callback The callback function called when the target is created. Parameters are
     * @param {Ametys.message.MessageTarget[]} callback.targets The targets created. Cannot be null.
     */
    createTargets: function(parameters, callback)
    {
        if (parameters.id)
        {
        	Ametys.plugins.skinfactory.model.SkinModelDAO.getModel([parameters.id], this._createTargets, {scope: this, arguments: {callback: callback, parameters: parameters}});
        }
    },

    /**
     * @private
     * Create the skin model target
     * @param {Object} model The model
     * @param {Object} args the arguments 
     * @param {Function} args.callback The callback function called when the targets are created. Parameters are
     * @param {Ametys.message.MessageTarget[]} args.targets The targets created. Cannot be null.
     * @param {Object} args.parameters The initial parameters of the #createTargets method
     */
    _createTargets: function (model, args)
    {
        var target = Ext.create("Ametys.message.MessageTarget", {
            id: Ametys.message.MessageTarget.SKINMODEL,
            parameters: {
                name: model.name,
                title: model.title,
                isModifiable: model.isModifiable
            }
        });
        
        args.callback([target]);
    }
});


Ext.define("Ametys.message.SkinModelMessageTarget",
{
    override: "Ametys.message.MessageTarget",

    statics: 
    {
        /**
         * @member Ametys.message.MessageTarget
         * @readonly
         * @property {String} SKINMODEL The target type is a skin model. See Ametys.plugins.skinfactory.model.SkinModelMessageTargetFactory parameters to know more of the associated parameters. 
         */
        SKINMODEL: "skin-model",

        /**
         * @member Ametys.message.MessageTarget
         * @readonly
         * @property {String} SKINFILTER The target type is a skin filter. The expected parameters are:
         * @property {String} SKINFILTER.id The name of the model to filter.
         * @property {String} SKINFILTER.label The name of the model to filter.
         */
        SKINFILTER: "skin-filter"
    }
});
