/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.skinfactory.model;

import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.core.cache.AbstractCacheManager;
import org.ametys.core.cache.Cache;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.skinfactory.SkinFactoryComponent;
import org.ametys.skinfactory.parameters.AbstractSkinParameter;
import org.ametys.skinfactory.parameters.I18nizableTextParameter;
import org.ametys.skinfactory.parameters.ImageParameter;
import org.ametys.web.skin.SkinModel;
import org.ametys.web.skin.SkinModelsManager;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.commons.lang3.StringUtils;

public class ModelDesignsManager
extends AbstractLogEnabled
implements ThreadSafe,
Serviceable,
Initializable,
Component {
    public static final String ROLE = ModelDesignsManager.class.getName();
    private static final String __MODEL_DESIGN_CACHE = ModelDesignsManager.class.getName() + "$modelDesign";
    private SkinModelsManager _modelsManager;
    private SkinFactoryComponent _skinFactoryManager;
    private AbstractCacheManager _cacheManager;

    public void service(ServiceManager smanager) throws ServiceException {
        this._modelsManager = (SkinModelsManager)smanager.lookup(SkinModelsManager.ROLE);
        this._skinFactoryManager = (SkinFactoryComponent)((Object)smanager.lookup(SkinFactoryComponent.ROLE));
        this._cacheManager = (AbstractCacheManager)smanager.lookup(AbstractCacheManager.ROLE);
    }

    public void initialize() throws Exception {
        this._cacheManager.createMemoryCache(__MODEL_DESIGN_CACHE, new I18nizableText("plugin.skinfactory", "PLUGINS_SKINFACTORY_CACHE_MODEL_DESIGN_LABEL"), new I18nizableText("plugin.skinfactory", "PLUGINS_SKINFACTORY_CACHE_MODEL_DESIGN_DESCRIPTION"), true, null);
    }

    public Set<Design> getDesigns(String modelName) {
        return (Set)this._getDesignCache().get((Object)modelName, this::_getDesigns);
    }

    public Design getDesign(String modelName, String id) {
        Set designs = (Set)this._getDesignCache().get((Object)modelName, this::_getDesigns);
        return designs.stream().filter(design -> StringUtils.equals((CharSequence)design.getId(), (CharSequence)id)).findFirst().orElse(null);
    }

    public void applyDesign(String modelName, String id, Path skinDir) {
        SkinModel model = this._modelsManager.getModel(modelName);
        Path file = model.getPath().resolve("model/designs/" + id + ".xml");
        if (Files.exists(file, new LinkOption[0])) {
            String themeId = this._getColorTheme(file);
            if (themeId != null) {
                this._skinFactoryManager.saveColorTheme(skinDir, themeId);
            }
            Map<String, Object> values = this._getParameterValues(modelName, file);
            this._skinFactoryManager.applyModelParameters(modelName, skinDir, values);
        }
    }

    private Set<Design> _getDesigns(String modelName) {
        Set<Design> designs;
        SkinModel model = this._modelsManager.getModel(modelName);
        Path designDir = model.getPath().resolve("model/designs");
        if (Files.exists(designDir, new LinkOption[0])) {
            try {
                designs = Files.walk(designDir, 1, new FileVisitOption[0]).filter(f -> f.getFileName().toString().toLowerCase().endsWith(".xml")).map(f -> this._configureDesign(modelName, (Path)f)).filter(design -> design != null).collect(Collectors.toSet());
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot read the configuration file model/designs for the model " + modelName);
            }
        } else {
            designs = new HashSet<Design>();
        }
        return designs;
    }

    private Design _configureDesign(String modelName, Path configurationFile) {
        Design design;
        block10: {
            InputStream is = Files.newInputStream(configurationFile, new OpenOption[0]);
            try {
                String fileName = configurationFile.getFileName().toString();
                String id = fileName.substring(0, fileName.lastIndexOf("."));
                Configuration configuration = new DefaultConfigurationBuilder().build(is);
                I18nizableText label = this._configureI18nizableText(configuration.getChild("label", false), new I18nizableText(id), modelName);
                I18nizableText description = this._configureI18nizableText(configuration.getChild("description", false), new I18nizableText(id), modelName);
                String iconName = id + ".png";
                Object icon = "/plugins/skinfactory/resources/img/actions/designs_32.png";
                Path iconFile = configurationFile.getParent().resolve(iconName);
                if (Files.exists(iconFile, new LinkOption[0])) {
                    icon = "/plugins/skinfactory/" + modelName + "/_thumbnail/32/32/model/designs/" + iconName;
                }
                design = new Design(id, label, description, (String)icon);
                if (is == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    if (this.getLogger().isWarnEnabled()) {
                        this.getLogger().warn("Cannot read the configuration file model/designs/" + configurationFile.getFileName().toString() + " for the model '" + modelName + "'. Continue as if file was not existing", (Throwable)e);
                    }
                    return null;
                }
            }
            is.close();
        }
        return design;
    }

    private String _getColorTheme(Path file) {
        String string;
        block8: {
            InputStream is = Files.newInputStream(file, new OpenOption[0]);
            try {
                Configuration configuration = new DefaultConfigurationBuilder(true).build(is);
                string = configuration.getChild("color-theme").getValue(null);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.getLogger().error("Unable to get color theme", (Throwable)e);
                    return null;
                }
            }
            is.close();
        }
        return string;
    }

    private Map<String, Object> _getParameterValues(String modelName, Path file) {
        HashMap<String, Object> hashMap;
        block12: {
            HashMap<String, Object> values = new HashMap<String, Object>();
            InputStream is = Files.newInputStream(file, new OpenOption[0]);
            try {
                Configuration configuration = new DefaultConfigurationBuilder(true).build(is);
                Configuration[] parametersConf = configuration.getChild("parameters").getChildren("parameter");
                Map<String, AbstractSkinParameter> modelParameters = this._skinFactoryManager.getModelParameters(modelName);
                for (Configuration paramConf : parametersConf) {
                    String id = paramConf.getAttribute("id");
                    AbstractSkinParameter modelParam = modelParameters.get(id);
                    if (modelParam == null) continue;
                    if (modelParam instanceof I18nizableTextParameter) {
                        Configuration[] children = paramConf.getChildren();
                        HashMap<String, String> langValues = new HashMap<String, String>();
                        for (Configuration langConfig : children) {
                            langValues.put(langConfig.getName(), langConfig.getValue(""));
                        }
                        values.put(id, langValues);
                        continue;
                    }
                    if (modelParam instanceof ImageParameter) {
                        values.put(id, new ImageParameter.FileValue(paramConf.getValue(""), false));
                        continue;
                    }
                    values.put(id, paramConf.getValue(""));
                }
                hashMap = values;
                if (is == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.getLogger().error("Unable to get values of all parameters", (Throwable)e);
                    return new HashMap<String, Object>();
                }
            }
            is.close();
        }
        return hashMap;
    }

    private I18nizableText _configureI18nizableText(Configuration configuration, I18nizableText defaultValue, String modelName) throws ConfigurationException {
        if (configuration != null) {
            boolean i18nSupported = configuration.getAttributeAsBoolean("i18n", false);
            if (i18nSupported) {
                Object catalogue = configuration.getAttribute("catalogue", null);
                if (catalogue == null) {
                    catalogue = "model." + modelName;
                }
                return new I18nizableText((String)catalogue, configuration.getValue());
            }
            return new I18nizableText(configuration.getValue(""));
        }
        return defaultValue;
    }

    private Cache<String, Set<Design>> _getDesignCache() {
        return this._cacheManager.get(__MODEL_DESIGN_CACHE);
    }

    public static class Design {
        private String _id;
        private I18nizableText _label;
        private I18nizableText _description;
        private String _icon;

        public Design(String id, I18nizableText label, I18nizableText description, String icon) {
            this._id = id;
            this._label = label;
            this._description = description;
            this._icon = icon;
        }

        public String getId() {
            return this._id;
        }

        public I18nizableText getLabel() {
            return this._label;
        }

        public I18nizableText getDescription() {
            return this._description;
        }

        public String getIcon() {
            return this._icon;
        }
    }
}

