/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.skinfactory.parameters;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.skinfactory.parameters.AbstractSkinParameter;
import org.ametys.skinfactory.parameters.SkinParameterException;
import org.ametys.web.skin.SkinModel;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.io.IOUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ImageParameter
extends AbstractSkinParameter {
    private String _iconGlyph;
    private String _iconSmall;
    private String _iconLarge;
    private boolean _localUploadEnabled;
    private String _imagePath;

    public ImageParameter(String relPath, I18nizableText label, I18nizableText description) {
        super(relPath.replaceAll("\\\\", "/"), label, description);
        this._imagePath = relPath.replaceAll("\\\\", "/");
        this._localUploadEnabled = false;
    }

    public ImageParameter(String relPath, I18nizableText label, I18nizableText description, String iconGlyph, String iconSmall, String iconLarge) {
        super(relPath.replaceAll("\\\\", "/"), label, description);
        this._imagePath = relPath.replaceAll("\\\\", "/");
        this._localUploadEnabled = false;
        this._iconGlyph = iconGlyph;
        this._iconLarge = iconLarge;
        this._iconSmall = iconSmall;
    }

    @Override
    public AbstractSkinParameter.SkinParameterType getType() {
        return AbstractSkinParameter.SkinParameterType.IMAGE;
    }

    public boolean isLocalUploadEnabled() {
        return this._localUploadEnabled;
    }

    public String getLibraryPath() {
        return this._imagePath;
    }

    public void setIconGlyph(String iconGlyph) {
        this._iconGlyph = iconGlyph;
    }

    public String getIconGlyph() {
        return this._iconGlyph;
    }

    public void setIconSmall(String iconSmall) {
        this._iconSmall = iconSmall;
    }

    public String getIconSmall() {
        return this._iconSmall;
    }

    public void setIconLarge(String iconLarge) {
        this._iconLarge = iconLarge;
    }

    public String getIconLarge() {
        return this._iconLarge;
    }

    @Override
    public void apply(Path tempDir, Path modelDir, Object value, String lang) {
        Path targetFile = tempDir.resolve("resources/img/" + this._imagePath);
        boolean uploaded = value instanceof FileValue ? ((FileValue)value).isUploaded() : false;
        Path libraryFile = this._getLibraryFile(tempDir, modelDir, uploaded);
        String filePath = value instanceof FileValue ? ((FileValue)value).getPath() : (String)value;
        Path srcFile = libraryFile.resolve(filePath);
        this._copyFile(srcFile, targetFile);
        Path resourcesFile = tempDir.resolve("resources");
        try {
            for (Path file : this._listCSSFiles(resourcesFile)) {
                Files.setLastModifiedTime(file, FileTime.fromMillis(System.currentTimeMillis()));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("An error occurred while retrieving CSS files in " + resourcesFile.toString());
        }
    }

    private List<Path> _listCSSFiles(Path file) throws IOException {
        return Files.walk(file, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(f -> f.getFileName().toString().endsWith(".css")).collect(Collectors.toList());
    }

    private Path _getLibraryFile(Path tempDir, Path modelDir, boolean uploaded) {
        if (uploaded) {
            return tempDir.resolve("model/_uploads/" + this._imagePath);
        }
        return modelDir.resolve("model/images/" + this._imagePath);
    }

    private void _copyFile(Path srcFile, Path targetFile) {
        if (!Files.exists(srcFile, new LinkOption[0])) {
            return;
        }
        try {
            Files.createDirectories(targetFile.getParent(), new FileAttribute[0]);
            try (InputStream is = Files.newInputStream(srcFile, new OpenOption[0]);
                 OutputStream os = Files.newOutputStream(targetFile, new OpenOption[0]);){
                IOUtils.copy((InputStream)is, (OutputStream)os);
                Files.setLastModifiedTime(targetFile, FileTime.fromMillis(System.currentTimeMillis()));
            }
        }
        catch (IOException e) {
            throw new SkinParameterException("Unable to apply image parameter '" + this.getId() + "'", e);
        }
    }

    @Override
    public void toSAX(ContentHandler contentHandler, String modelName) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("id", this.getId());
        attrs.addCDATAAttribute("type", AbstractSkinParameter.SkinParameterType.IMAGE.name().toLowerCase());
        XMLUtils.startElement((ContentHandler)contentHandler, (String)"parameter", (Attributes)attrs);
        this.getLabel().toSAX(contentHandler, "label");
        this.getDescription().toSAX(contentHandler, "description");
        XMLUtils.createElement((ContentHandler)contentHandler, (String)"path", (String)this._imagePath);
        if (this.getIconGlyph() != null) {
            XMLUtils.createElement((ContentHandler)contentHandler, (String)"iconGlyph", (String)this.getIconGlyph());
        }
        if (this.getIconSmall() != null) {
            XMLUtils.createElement((ContentHandler)contentHandler, (String)"iconSmall", (String)("/plugins/skinfactory/" + modelName + "/_thumbnail/16/16/model/images/" + this._imagePath + "/" + this.getIconSmall()));
        } else {
            XMLUtils.createElement((ContentHandler)contentHandler, (String)"iconSmall", (String)"/plugins/skinfactory/resources/img/button/image_16.png");
        }
        if (this.getIconLarge() != null) {
            XMLUtils.createElement((ContentHandler)contentHandler, (String)"iconLarge", (String)("/plugins/skinfactory/" + modelName + "/_thumbnail/32/32/model/images/" + this._imagePath + "/" + this.getIconLarge()));
        } else {
            XMLUtils.createElement((ContentHandler)contentHandler, (String)"iconLarge", (String)"/plugins/skinfactory/resources/img/button/image_32.png");
        }
        XMLUtils.endElement((ContentHandler)contentHandler, (String)"parameter");
    }

    @Override
    public Map<String, Object> toJson(String modelName) {
        HashMap<String, Object> jsonObject = new HashMap<String, Object>();
        jsonObject.put("id", this.getId());
        jsonObject.put("type", AbstractSkinParameter.SkinParameterType.IMAGE.name().toLowerCase());
        jsonObject.put("label", this.getLabel());
        jsonObject.put("description", this.getDescription());
        jsonObject.put("path", this._imagePath);
        if (this.getIconGlyph() != null) {
            jsonObject.put("iconGlyph", this.getIconGlyph());
        }
        if (this.getIconSmall() != null) {
            jsonObject.put("iconSmall", "/plugins/skinfactory/" + modelName + "/_thumbnail/16/16/model/images/" + this._imagePath + "/" + this.getIconSmall());
        } else {
            jsonObject.put("iconSmall", "/plugins/skinfactory/resources/img/button/image_16.png");
        }
        if (this.getIconLarge() != null) {
            jsonObject.put("iconLarge", "/plugins/skinfactory/" + modelName + "/_thumbnail/32/32/model/images/" + this._imagePath + "/" + this.getIconLarge());
        } else {
            jsonObject.put("iconLarge", "/plugins/skinfactory/resources/img/button/image_32.png");
        }
        return jsonObject;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FileValue getDefaultValue(SkinModel model) {
        Path libraryFile = model.getPath().resolve("model/images/" + this._imagePath);
        try (Stream<Path> s = Files.list(libraryFile);){
            Path file;
            block20: {
                List files = s.collect(Collectors.toList());
                Iterator iterator = files.iterator();
                block15: while (iterator.hasNext()) {
                    file = (Path)iterator.next();
                    if (Files.isDirectory(file, new LinkOption[0])) {
                        Stream<Path> s2 = Files.list(file);
                        try {
                            Path child;
                            List subfiles = s2.collect(Collectors.toList());
                            Iterator iterator2 = subfiles.iterator();
                            do {
                                if (!iterator2.hasNext()) continue block15;
                            } while (!this._isImage(child = (Path)iterator2.next()));
                            String defaultPath = libraryFile.relativize(child).toString();
                            defaultPath.replaceAll((String)(File.separator.equals("\\") ? File.separator + File.separator : File.separator), ".");
                            FileValue fileValue = new FileValue(defaultPath, false);
                            return fileValue;
                        }
                        finally {
                            if (s2 == null) continue;
                            s2.close();
                            continue;
                        }
                    }
                    if (!this._isImage(file)) {
                        continue;
                    }
                    break block20;
                }
                return null;
            }
            String defaultPath = libraryFile.relativize(file).toString();
            defaultPath.replaceAll((String)(File.separator.equals("\\") ? File.separator + File.separator : File.separator), ".");
            FileValue fileValue = new FileValue(defaultPath, false);
            return fileValue;
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot get default value for model " + model.getId(), e);
        }
    }

    private boolean _isImage(Path file) {
        if (Files.isDirectory(file, new LinkOption[0])) {
            return false;
        }
        String name = file.getFileName().toString().toLowerCase();
        int index = name.lastIndexOf(".");
        String ext = name.substring(index + 1);
        if (name.equals("thumbnail_16.png") || name.equals("thumbnail_32.png") || name.equals("thumbnail_48.png")) {
            return false;
        }
        return "png".equals(ext) || "gif".equals(ext) || "jpg".equals(ext) || "jpeg".equals(ext);
    }

    @Override
    public FileValue getDefaultValue(SkinModel model, String lang) {
        return this.getDefaultValue(model);
    }

    public static class FileValue {
        private String _path;
        private boolean _uploaded;

        public FileValue(String path, boolean uploaded) {
            this._uploaded = uploaded;
            this._path = path;
        }

        public boolean isUploaded() {
            return this._uploaded;
        }

        public String getPath() {
            return this._path;
        }
    }
}

