/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.skinfactory.parameters;

import java.nio.file.Path;
import java.util.Map;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.skin.SkinModel;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class AbstractSkinParameter {
    String _id;
    I18nizableText _label;
    I18nizableText _description;

    public AbstractSkinParameter(String id, I18nizableText label, I18nizableText description) {
        this._id = id;
        this._label = label;
        this._description = description;
    }

    public String getId() {
        return this._id;
    }

    public I18nizableText getLabel() {
        return this._label != null ? this._label : new I18nizableText(this._id);
    }

    public void setLabel(I18nizableText label) {
        this._label = label;
    }

    public I18nizableText getDescription() {
        return this._description != null ? this._description : new I18nizableText("");
    }

    public void setDescription(I18nizableText description) {
        this._description = description;
    }

    public abstract SkinParameterType getType();

    public abstract void apply(Path var1, Path var2, Object var3, String var4);

    public abstract void toSAX(ContentHandler var1, String var2) throws SAXException;

    public abstract Map<String, Object> toJson(String var1);

    public abstract Object getDefaultValue(SkinModel var1);

    public abstract Object getDefaultValue(SkinModel var1, String var2);

    public class Widget {
        String _group;
        String[] _params;
        String _name;

        public Widget(AbstractSkinParameter this$0, String name, String group, String[] params) {
            this._name = name;
            this._group = group;
            this._params = params;
        }
    }

    public static enum SkinParameterType {
        IMAGE,
        CSS,
        VARIANT,
        TEXT,
        I18N;

    }
}

