/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.skinfactory.skins;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Stream;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.ametys.cms.languages.Language;
import org.ametys.cms.languages.LanguagesManager;
import org.ametys.core.right.RightManager;
import org.ametys.core.ui.Callable;
import org.ametys.core.upload.Upload;
import org.ametys.core.upload.UploadManager;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.util.I18nUtils;
import org.ametys.core.util.LambdaUtils;
import org.ametys.core.util.path.PathUtils;
import org.ametys.plugins.skincommons.AbstractCommonSkinDAO;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.skinfactory.SkinFactoryComponent;
import org.ametys.skinfactory.filefilter.FileFilter;
import org.ametys.skinfactory.model.ModelDesignsManager;
import org.ametys.skinfactory.parameters.AbstractSkinParameter;
import org.ametys.skinfactory.parameters.I18nizableTextParameter;
import org.ametys.skinfactory.parameters.ImageParameter;
import org.ametys.skinfactory.parameters.SkinParameterException;
import org.ametys.skinfactory.parameters.Variant;
import org.ametys.skinfactory.parameters.VariantParameter;
import org.ametys.web.repository.site.Site;
import org.ametys.web.skin.Skin;
import org.ametys.web.skin.SkinModel;
import org.ametys.web.skin.SkinModelsManager;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SkinDAO
extends AbstractCommonSkinDAO {
    public static final String SKIN_FACTORY_TOOL_ID = "uitool-skinfactory";
    private static final DateFormat _DATE_FORMAT = new SimpleDateFormat("yyyyMMdd-HHmm");
    private static final String __WORK_MODE = "work";
    private static final String __PROD_MODE = "prod";
    private I18nUtils _i18nUtils;
    private LanguagesManager _languageManager;
    private ModelDesignsManager _designsManager;
    private SkinFactoryComponent _skinFactoryManager;
    private SkinModelsManager _modelsManager;
    private UploadManager _uploadManager;
    private RightManager _rightManager;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._designsManager = (ModelDesignsManager)((Object)manager.lookup(ModelDesignsManager.ROLE));
        this._i18nUtils = (I18nUtils)manager.lookup(I18nUtils.ROLE);
        this._languageManager = (LanguagesManager)manager.lookup(LanguagesManager.ROLE);
        this._modelsManager = (SkinModelsManager)manager.lookup(SkinModelsManager.ROLE);
        this._skinFactoryManager = (SkinFactoryComponent)((Object)manager.lookup(SkinFactoryComponent.ROLE));
        this._userManager = (UserManager)manager.lookup(UserManager.ROLE);
        this._uploadManager = (UploadManager)manager.lookup(UploadManager.ROLE);
        this._rightManager = (RightManager)manager.lookup(RightManager.ROLE);
    }

    protected void checkUserRight(String skinName) {
        UserIdentity user = this._userProvider.getUser();
        if (!this._skinsManager.getSkinNameFromRequest().equals(skinName) || this._rightManager.hasRight(user, "Plugins_SkinFactory_EditCurrentSkin", (Object)"/${WorkspaceName}") != RightManager.RightResult.RIGHT_ALLOW) {
            throw new AccessDeniedException("User '" + String.valueOf(user) + "' tried perform operation on skin '" + skinName + "' without sufficient right");
        }
    }

    protected Map<String, Object> checkLock(Path skinDir) throws IOException {
        if (!this._lockManager.canWrite(skinDir)) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            UserIdentity lockOwner = this._lockManager.getLockOwner(skinDir);
            User user = this._userManager.getUser(lockOwner.getPopulationId(), lockOwner.getLogin());
            result.put("isLocked", true);
            result.put("lockOwner", user != null ? user.getFullName() + " (" + String.valueOf(lockOwner) + ")" : lockOwner);
            return result;
        }
        return null;
    }

    @Callable(rights={"Plugins_SkinFactory_EditCurrentSkin"}, context="/cms")
    public Map<String, Object> affectDesign(String skinName, String designId) throws IOException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Path tempDir = this._skinHelper.getTempDirectory(skinName);
        String modelName = this._skinHelper.getTempModel(skinName);
        Map<String, Object> lockInfos = this.checkLock(tempDir);
        if (lockInfos != null) {
            return lockInfos;
        }
        if (this._modelsManager.getModel(modelName) == null) {
            result.put("unknownModel", true);
            result.put("modelName", modelName);
            return result;
        }
        this._designsManager.applyDesign(modelName, designId, tempDir);
        HashMap<String, Object> values = new HashMap<String, Object>(this._skinFactoryManager.getParameterValues(tempDir, modelName));
        result.put("parameters", values);
        String colorTheme = this._skinFactoryManager.getColorTheme(tempDir);
        if (colorTheme != null) {
            result.put("themeId", colorTheme);
            result.put("colors", this._modelsManager.getModel(modelName).getColors(colorTheme));
        }
        result.put("designId", designId);
        return result;
    }

    @Callable(rights={"Plugins_SkinFactory_EditCurrentSkin"}, context="/cms")
    public Map<String, Object> changeModel(String modelName, String skinName, boolean useDefaults) throws IOException, TransformerConfigurationException, SAXException {
        Path tempDir = this._skinHelper.getTempDirectory(skinName);
        Map<String, Object> lockInfos = this.checkLock(tempDir);
        if (lockInfos != null) {
            return lockInfos;
        }
        String currentTheme = this._skinFactoryManager.getColorTheme(tempDir);
        Path tmpDir = tempDir.getParent().resolve(skinName + "." + _DATE_FORMAT.format(new Date()));
        Path modelDir = this._modelsManager.getModel(modelName).getPath();
        PathUtils.copyDirectory((Path)modelDir, (Path)tmpDir, f -> !f.getFileName().equals("model"), (boolean)false);
        this._modelsManager.generateModelFile(tmpDir, modelName, currentTheme);
        if (useDefaults) {
            String defaultColorTheme = this._modelsManager.getModel(modelName).getDefaultColorTheme();
            this._skinFactoryManager.saveColorTheme(tmpDir, defaultColorTheme);
            this._skinFactoryManager.applyModelParameters(modelName, tmpDir);
        } else {
            Map<String, Object> currentValues = this._skinFactoryManager.getParameterValues(tempDir, modelName);
            this._skinFactoryManager.applyModelParameters(modelName, tmpDir, currentValues);
        }
        this._skinHelper.deleteQuicklyDirectory(tempDir);
        PathUtils.moveDirectory((Path)tmpDir, (Path)tempDir);
        this._skinHelper.invalidateTempSkinCatalogues(skinName);
        this._lockManager.updateLockFile(tempDir, SKIN_FACTORY_TOOL_ID);
        return new HashMap<String, Object>(this._skinFactoryManager.getParameterValues(tempDir, modelName));
    }

    @Callable(rights={"*"})
    public Map<String, Object> getLanguages(String siteName) {
        LinkedHashMap<String, Object> languages = new LinkedHashMap<String, Object>();
        Site site = this._siteManager.getSite(siteName);
        Skin skin = this._skinsManager.getSkin(site.getSkinId());
        Path i18nDir = skin.getRawPath().resolve("i18n");
        Map allLanguages = this._languageManager.getAvailableLanguages();
        try (Stream<Path> files = Files.list(i18nDir);){
            files.forEach(file -> {
                String fileName = file.getFileName().toString();
                if (!Files.isDirectory(file, new LinkOption[0]) && fileName.startsWith("messages")) {
                    String lang = null;
                    lang = fileName.equals("messages.xml") ? this._getDefaultLanguage((Path)file) : fileName.substring("messages_".length(), fileName.lastIndexOf("."));
                    if (allLanguages.containsKey(lang)) {
                        Language language = (Language)allLanguages.get(lang);
                        HashMap<String, Object> langParams = new HashMap<String, Object>();
                        langParams.put("label", language.getLabel());
                        langParams.put("iconSmall", language.getSmallIcon());
                        langParams.put("iconMedium", language.getMediumIcon());
                        langParams.put("iconLarge", language.getLargeIcon());
                        languages.put(lang, langParams);
                    }
                }
            });
        }
        catch (IOException e) {
            this.getLogger().error("Cannot get languages for site " + siteName, (Throwable)e);
        }
        return languages;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String _getDefaultLanguage(Path i18nFile) {
        try (InputStream is = Files.newInputStream(i18nFile, new OpenOption[0]);){
            String string3 = IOUtils.toString((InputStream)is, (String)"UTF-8");
            int i = string3.indexOf("xml:lang=\"");
            if (i != -1) {
                String string2 = string3.substring(i + "xml:lang=\"".length(), i + "xml:lang=\"".length() + 2);
                return string2;
            }
            String string = null;
            return string;
        }
        catch (IOException e) {
            throw new SkinParameterException("Unable to parse file '" + i18nFile.getFileName().toString() + "'", e);
        }
    }

    @Callable(rights={"*"})
    public Map<String, Object> getColors(String siteName) {
        SkinModel.Theme theme;
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        Site site = this._siteManager.getSite(siteName);
        String skinId = site.getSkinId();
        String modelName = this._skinHelper.getTempModel(skinId);
        Path tempDir = this._skinHelper.getTempDirectory(skinId);
        String colorTheme = this._skinFactoryManager.getColorTheme(tempDir);
        SkinModel model = this._modelsManager.getModel(modelName);
        List defaultColors = model.getDefaultColors();
        params.put("colors", defaultColors);
        if (StringUtils.isNotEmpty((CharSequence)colorTheme) && (theme = model.getTheme(colorTheme)) != null) {
            params.put("themeId", theme.getId());
            params.put("themeColors", theme.getColors());
        }
        return params;
    }

    @Callable(rights={"*"})
    public Map<String, Object> getCssStyleItems(String siteName) {
        LinkedHashMap<String, Object> styles = new LinkedHashMap<String, Object>();
        Site site = this._siteManager.getSite(siteName);
        String skinId = site.getSkinId();
        String modelName = this._skinHelper.getTempModel(skinId);
        Map styleItems = this._modelsManager.getModel(modelName).getStyleItems();
        for (String styleId : styleItems.keySet()) {
            ArrayList<Object> menuItems = new ArrayList<Object>();
            List items = (List)styleItems.get(styleId);
            for (SkinModel.CssMenuItem item : items) {
                if (item instanceof SkinModel.CssStyleItem) {
                    String cssClass;
                    String icon;
                    SkinModel.CssStyleItem cssItem = (SkinModel.CssStyleItem)item;
                    HashMap<String, String> itemParams = new HashMap<String, String>();
                    itemParams.put("value", cssItem.getValue());
                    itemParams.put("label", this._i18nUtils.translate((I18nizable)cssItem.getLabel()));
                    String iconCls = cssItem.getIconCls();
                    if (iconCls != null) {
                        itemParams.put("iconCls", iconCls);
                    }
                    if ((icon = cssItem.getIcon()) != null) {
                        itemParams.put("icon", icon);
                    }
                    if ((cssClass = cssItem.getCssClass()) != null) {
                        itemParams.put("cssclass", cssClass);
                    }
                    menuItems.add(itemParams);
                    continue;
                }
                if (!(item instanceof SkinModel.Separator)) continue;
                menuItems.add("separator");
            }
            styles.put(styleId, menuItems);
        }
        return styles;
    }

    @Callable(rights={"*"})
    public Map<String, Object> getParametersValues(String siteName, List<String> paramIds) {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        Site site = this._siteManager.getSite(siteName);
        String skinId = site.getSkinId();
        String modelName = this._skinHelper.getTempModel(skinId);
        Path tempDir = this._skinHelper.getTempDirectory(skinId);
        if (paramIds != null) {
            values.putAll(this._skinFactoryManager.getParameterValues(tempDir, modelName, paramIds));
        } else {
            values.putAll(this._skinFactoryManager.getParameterValues(tempDir, modelName));
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("skinName", skinId);
        result.put("modelName", modelName);
        result.put("siteName", siteName);
        result.put("values", values);
        return result;
    }

    @Callable(rights={"Plugins_SkinFactory_EditCurrentSkin"}, context="/cms")
    public Map<String, String> openSkin(String siteName, String mode) throws IOException {
        HashMap<String, String> result = new HashMap<String, String>();
        Site site = this._siteManager.getSite(siteName);
        String skinId = site.getSkinId();
        Skin skin = this._skinsManager.getSkin(skinId);
        if (!skin.isModifiable()) {
            throw new IllegalStateException("The skin '" + skinId + "' is not modifiable and thus cannot be opened in skin editor.");
        }
        Path tempDir = this._skinHelper.getTempDirectory(skinId);
        Path workDir = this._skinHelper.getWorkDirectory(skinId);
        Path skinDir = this._skinHelper.getSkinDirectory(skinId);
        String modelName = null;
        modelName = __PROD_MODE.equals(mode) ? this._skinHelper.getSkinModel(skinId) : (__WORK_MODE.equals(mode) ? this._skinHelper.getWorkModel(skinId) : this._skinHelper.getTempModel(skinId));
        SkinModel model = this._modelsManager.getModel(modelName);
        if (model == null) {
            result.put("model-not-found", "true");
            return result;
        }
        String modelHash = this._modelsManager.getModelHash(modelName);
        if (__PROD_MODE.equals(mode) || __WORK_MODE.equals(mode)) {
            boolean isUpTodate;
            if (Files.exists(tempDir, new LinkOption[0])) {
                this._skinHelper.deleteQuicklyDirectory(tempDir);
            }
            if (__PROD_MODE.equals(mode)) {
                if (Files.exists(workDir, new LinkOption[0])) {
                    this._skinHelper.deleteQuicklyDirectory(workDir);
                }
                PathUtils.copyDirectory((Path)skinDir, (Path)workDir, FileFilter.getSkinFileFilter());
            }
            if (!(isUpTodate = modelHash.equals(this._getHash(workDir)))) {
                this._reapplyModel(workDir, model.getPath(), modelHash);
            }
            this._skinFactoryManager.applyModelParameters(modelName, workDir);
            PathUtils.copyDirectory((Path)workDir, (Path)tempDir);
            this._lockManager.updateLockFile(tempDir, SKIN_FACTORY_TOOL_ID);
        } else {
            boolean isUpTodate = modelHash.equals(this._getHash(tempDir));
            if (!isUpTodate) {
                this._reapplyModel(tempDir, model.getPath(), modelHash);
            }
            this._skinFactoryManager.applyModelParameters(modelName, tempDir);
            this._lockManager.updateLockFile(tempDir, SKIN_FACTORY_TOOL_ID);
        }
        result.put("skinId", skinId);
        return result;
    }

    private void _reapplyModel(Path skinDir, Path modelDir, String hash) throws IOException {
        Path xmlFile = skinDir.resolve("model.xml");
        this._preserveFile(skinDir, xmlFile);
        Path uploadDir = skinDir.resolve("model/_uploads");
        if (Files.exists(uploadDir, new LinkOption[0])) {
            this._preserveFile(skinDir, uploadDir.getParent());
        }
        PathUtils.deleteQuietly((Path)skinDir);
        PathUtils.copyDirectory((Path)modelDir, (Path)skinDir, FileFilter.getModelFilter(modelDir), (boolean)false);
        this._copyFilesToPreserve(skinDir);
        this._skinFactoryManager.updateHash(xmlFile, hash);
    }

    private void _preserveFile(Path skinDir, Path fileToPreserve) throws IOException {
        Path toPreserveDir = skinDir.getParent().resolve(skinDir.getFileName().toString() + "_tmp");
        if (Files.isDirectory(fileToPreserve, new LinkOption[0])) {
            PathUtils.moveDirectoryToDirectory((Path)fileToPreserve, (Path)toPreserveDir, (boolean)true);
        } else {
            PathUtils.moveFileToDirectory((Path)fileToPreserve, (Path)toPreserveDir, (boolean)true);
        }
    }

    private void _copyFilesToPreserve(Path skinDir) throws IOException {
        Path toPreserveDir = skinDir.getParent().resolve(skinDir.getFileName().toString() + "_tmp");
        if (Files.exists(toPreserveDir, new LinkOption[0])) {
            try (Stream<Path> children = Files.list(toPreserveDir);){
                children.forEach(LambdaUtils.wrapConsumer(child -> {
                    if (Files.isDirectory(child, new LinkOption[0])) {
                        PathUtils.moveDirectoryToDirectory((Path)child, (Path)skinDir, (boolean)false);
                    } else {
                        PathUtils.moveFileToDirectory((Path)child, (Path)skinDir, (boolean)false);
                    }
                }));
            }
            catch (LambdaUtils.LambdaException e) {
                throw (IOException)e.getCause();
            }
            PathUtils.deleteQuietly((Path)toPreserveDir);
        }
    }

    private String _getHash(Path skinDir) {
        String string;
        block10: {
            Path modelFile = skinDir.resolve("model.xml");
            if (!Files.exists(modelFile, new LinkOption[0])) {
                return null;
            }
            InputStream is = Files.newInputStream(modelFile, new OpenOption[0]);
            try {
                XPath xpath = XPathFactory.newInstance().newXPath();
                string = xpath.evaluate("model/@hash", new InputSource(is));
                if (is == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (XPathExpressionException e) {
                    throw new IllegalStateException("The id of model is missing", e);
                }
                catch (IOException e) {
                    this.getLogger().error("Can not determine the hash the skin", (Throwable)e);
                    return null;
                }
            }
            is.close();
        }
        return string;
    }

    @Callable(rights={"Plugins_SkinFactory_EditCurrentSkin"}, context="/cms")
    public Map<String, Object> restoreDefaults(String skinName) throws IOException, TransformerConfigurationException, SAXException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Path tempDir = this._skinHelper.getTempDirectory(skinName);
        String modelName = this._skinHelper.getTempModel(skinName);
        Map<String, Object> lockInfos = this.checkLock(tempDir);
        if (lockInfos != null) {
            return lockInfos;
        }
        if (this._modelsManager.getModel(modelName) == null) {
            result.put("unknownModel", true);
            result.put("modelName", modelName);
            return result;
        }
        Path tmpDir = tempDir.getParent().resolve(skinName + "." + _DATE_FORMAT.format(new Date()));
        SkinModel model = this._modelsManager.getModel(modelName);
        Path modelDir = model.getPath();
        PathUtils.copyDirectory((Path)modelDir, (Path)tmpDir, f -> !f.getFileName().toString().equals("model"), (boolean)false);
        this._modelsManager.generateModelFile(tmpDir, modelName);
        String defaultColorTheme = model.getDefaultColorTheme();
        if (defaultColorTheme != null) {
            this._skinFactoryManager.saveColorTheme(tmpDir, defaultColorTheme);
            result.put("themeId", defaultColorTheme);
            result.put("colors", model.getColors(defaultColorTheme));
        }
        this._skinFactoryManager.applyModelParameters(modelName, tmpDir);
        this._skinHelper.deleteQuicklyDirectory(tempDir);
        PathUtils.moveDirectory((Path)tmpDir, (Path)tempDir);
        this._skinHelper.invalidateTempSkinCatalogues(skinName);
        this._lockManager.updateLockFile(tempDir, SKIN_FACTORY_TOOL_ID);
        HashMap<String, Object> values = new HashMap<String, Object>(this._skinFactoryManager.getParameterValues(tempDir, modelName));
        result.put("parameters", values);
        return result;
    }

    @Callable(rights={"Plugins_SkinFactory_EditCurrentSkin"}, context="/cms")
    public Map<String, Object> updateColorTheme(String skinName, String themeId) throws IOException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Path tempDir = this._skinHelper.getTempDirectory(skinName);
        String modelName = this._skinHelper.getTempModel(skinName);
        Map<String, Object> lockInfos = this.checkLock(tempDir);
        if (lockInfos != null) {
            return lockInfos;
        }
        if (this._modelsManager.getModel(modelName) == null) {
            result.put("unknownModel", true);
            result.put("modelName", modelName);
            return result;
        }
        this._skinFactoryManager.saveColorTheme(tempDir, themeId);
        this._skinFactoryManager.applyColorTheme(modelName, tempDir);
        this._lockManager.updateLockFile(tempDir, SKIN_FACTORY_TOOL_ID);
        result.put("themeId", themeId);
        result.put("colors", this._modelsManager.getModel(modelName).getColors(themeId));
        return result;
    }

    @Callable(rights={"Plugins_SkinFactory_EditCurrentSkin"}, context="/cms")
    public Map<String, Object> updateParameter(String skinName, String lang, String parameterId, String value, boolean uploaded) throws IOException {
        Path tempDir = this._skinHelper.getTempDirectory(skinName);
        Map<String, Object> lockInfos = this.checkLock(tempDir);
        if (lockInfos != null) {
            return lockInfos;
        }
        String modelName = this._skinHelper.getTempModel(skinName);
        if (modelName == null) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("unknownModel", true);
            result.put("modelName", modelName);
            return result;
        }
        Map<String, AbstractSkinParameter> modelParameters = this._skinFactoryManager.getModelParameters(modelName);
        AbstractSkinParameter skinParameter = modelParameters.get(parameterId);
        if (skinParameter != null) {
            ImageParameter.FileValue fileValue;
            if (skinParameter instanceof ImageParameter) {
                fileValue = new ImageParameter.FileValue(value, uploaded);
                this._skinFactoryManager.applyParameter(skinParameter, tempDir, modelName, fileValue, lang);
            } else {
                this._skinFactoryManager.applyParameter(skinParameter, tempDir, modelName, value, lang);
            }
            if (skinParameter instanceof I18nizableTextParameter) {
                HashMap<String, String> values = new HashMap<String, String>();
                values.put(lang, value);
                this._skinFactoryManager.saveParameter(tempDir, parameterId, values);
                this._skinHelper.invalidateTempSkinCatalogue(skinName, lang);
            } else if (skinParameter instanceof ImageParameter) {
                fileValue = new ImageParameter.FileValue(value, uploaded);
                this._skinFactoryManager.saveParameter(tempDir, parameterId, fileValue);
            } else {
                this._skinFactoryManager.saveParameter(tempDir, parameterId, value);
            }
            this._lockManager.updateLockFile(tempDir, SKIN_FACTORY_TOOL_ID);
        }
        return new HashMap<String, Object>(this._skinFactoryManager.getParameterValues(tempDir, modelName));
    }

    @Callable(rights={"Plugins_SkinFactory_EditCurrentSkin"}, context="/cms")
    public Map<String, Object> uploadLocalImage(String uploadId, String fileName, String skinName, String parameterId) throws IOException {
        Path tempDir = this._skinHelper.getTempDirectory(skinName);
        Map<String, Object> lockInfos = this.checkLock(tempDir);
        if (lockInfos != null) {
            return lockInfos;
        }
        String modelName = this._skinHelper.getTempModel(skinName);
        if (modelName == null) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("unknownModel", true);
            result.put("modelName", modelName);
            return result;
        }
        ImageParameter imgParam = (ImageParameter)this._skinFactoryManager.getModelParamater(modelName, parameterId);
        Upload upload = null;
        try {
            upload = this._uploadManager.getUpload(this._userProvider.getUser(), uploadId);
            Path uploadDir = this._getUploadDir(tempDir, imgParam);
            Path uploadFile = uploadDir.resolve(fileName);
            try (OutputStream os = Files.newOutputStream(uploadFile, new OpenOption[0]);
                 InputStream is = upload.getInputStream();){
                IOUtils.copy((InputStream)is, (OutputStream)os);
            }
            catch (IOException iOException) {}
        }
        catch (NoSuchElementException e) {
            this.getLogger().error(String.format("Cannot find the temporary uploaded file for id '%s' and login '%s'.", uploadId, this._userProvider.getUser()), (Throwable)e);
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("uploadFailed", true);
            result.put("uploadId", uploadId);
            return result;
        }
        ImageParameter.FileValue fileValue = new ImageParameter.FileValue(fileName, true);
        this._skinFactoryManager.applyParameter(imgParam, tempDir, modelName, fileValue, null);
        this._skinFactoryManager.saveParameter(tempDir, imgParam.getId(), fileValue);
        this._lockManager.updateLockFile(tempDir, SKIN_FACTORY_TOOL_ID);
        return new HashMap<String, Object>(this._skinFactoryManager.getParameterValues(tempDir, modelName));
    }

    @Callable(rights={"Plugins_SkinFactory_EditCurrentSkin"}, context="/cms")
    public Map<String, Object> getGalleryImages(String skinName, String paramId) throws IOException {
        HashMap<String, Object> gallery = new HashMap<String, Object>();
        String modelName = this._skinHelper.getTempModel(skinName);
        SkinModel model = this._modelsManager.getModel(modelName);
        if (model != null) {
            AbstractSkinParameter skinParameter = this._skinFactoryManager.getModelParamater(modelName, paramId);
            if (skinParameter instanceof ImageParameter) {
                ImageParameter imageParam = (ImageParameter)skinParameter;
                Path imageDir = model.getPath().resolve("model/images");
                Path libraryFile = imageDir.resolve(imageParam.getLibraryPath());
                gallery.put("gallery", this._imageFiles2JsonObject(imageDir.toAbsolutePath().toString(), libraryFile.toAbsolutePath().toString(), libraryFile, modelName, true));
                Path tempDir = this._skinHelper.getTempDirectory(skinName);
                Path uploadDir = tempDir.resolve("model/_uploads/" + imageParam.getLibraryPath());
                if (Files.exists(uploadDir, new LinkOption[0])) {
                    gallery.put("uploadedGroup", this._uploadImages2JsonObject(uploadDir, skinName, imageParam));
                }
            }
        } else {
            this.getLogger().warn("Unable to get gallery images : the model '" + modelName + "' does not exist anymore");
        }
        return gallery;
    }

    private Map<String, Object> _uploadImages2JsonObject(Path uploadDir, String skinName, ImageParameter imageParam) throws IOException {
        HashMap<String, Object> uploadedGroup = new HashMap<String, Object>();
        uploadedGroup.put("label", new I18nizableText("plugin.skinfactory", "PLUGINS_SKINFACTORY_IMAGESGALLERY_GROUP_UPLOADED"));
        ArrayList uploadedImages = new ArrayList();
        try (Stream<Path> files = Files.list(uploadDir);){
            files.filter(f -> this._isImage((Path)f)).forEach(child -> {
                HashMap<String, Object> jsonObject = new HashMap<String, Object>();
                jsonObject.put("type", "image");
                jsonObject.put("filename", child.getFileName().toString());
                jsonObject.put("src", child.getFileName().toString());
                jsonObject.put("thumbnail", "/plugins/skinfactory/" + skinName + "/_thumbnail/64/64/model/_uploads/" + (imageParam.getLibraryPath() + "/" + child.getFileName().toString()).replaceAll("\\\\", "/"));
                jsonObject.put("thumbnailLarge", "/plugins/skinfactory/" + skinName + "/_thumbnail/100/100/model/_uploads/" + (imageParam.getLibraryPath() + "/" + child.getFileName().toString()).replaceAll("\\\\", "/"));
                jsonObject.put("uploaded", true);
                uploadedImages.add(jsonObject);
            });
        }
        uploadedGroup.put("images", uploadedImages);
        return uploadedGroup;
    }

    private List<Object> _imageFiles2JsonObject(String imageDirPath, String libraryDirPath, Path file, String modelName, boolean deep) throws IOException {
        ArrayList<Object> imageFilesJsonObject = new ArrayList<Object>();
        try (Stream<Path> children = Files.list(file);){
            children.forEach(LambdaUtils.wrapConsumer(child -> {
                HashMap<String, Object> jsonObject = new HashMap<String, Object>();
                if (Files.isDirectory(child, new LinkOption[0]) && deep && !child.getFileName().equals(".svn")) {
                    jsonObject.put("type", "group");
                    jsonObject.put("label", child.getFileName().toString());
                    jsonObject.put("childs", this._imageFiles2JsonObject(imageDirPath, libraryDirPath, (Path)child, modelName, false));
                    imageFilesJsonObject.add(jsonObject);
                } else if (this._isImage((Path)child)) {
                    jsonObject.put("type", "image");
                    jsonObject.put("filename", child.getFileName().toString());
                    jsonObject.put("src", child.toAbsolutePath().toString().substring(libraryDirPath.length() + 1).replaceAll("\\\\", "/"));
                    jsonObject.put("thumbnail", "/plugins/skinfactory/" + modelName + "/_thumbnail/64/64/model/images/" + child.toAbsolutePath().toString().substring(imageDirPath.length() + 1).replaceAll("\\\\", "/"));
                    jsonObject.put("thumbnailLarge", "/plugins/skinfactory/" + modelName + "/_thumbnail/100/100/model/images/" + child.toAbsolutePath().toString().substring(imageDirPath.length() + 1).replaceAll("\\\\", "/"));
                    imageFilesJsonObject.add(jsonObject);
                }
            }));
        }
        catch (LambdaUtils.LambdaException e) {
            throw (IOException)e.getCause();
        }
        return imageFilesJsonObject;
    }

    private Path _getUploadDir(Path tempDir, ImageParameter imgParam) throws IOException {
        Path uploadDir = tempDir.resolve("model/_uploads/" + imgParam.getLibraryPath());
        if (!Files.exists(uploadDir, new LinkOption[0])) {
            Files.createDirectories(uploadDir, new FileAttribute[0]);
        }
        return uploadDir;
    }

    private boolean _isImage(Path file) {
        String name = file.getFileName().toString().toLowerCase();
        int index = name.lastIndexOf(".");
        String ext = name.substring(index + 1);
        if (name.equals("thumbnail_16.png") || name.equals("thumbnail_32.png") || name.equals("thumbnail_48.png")) {
            return false;
        }
        return "png".equals(ext) || "gif".equals(ext) || "jpg".equals(ext) || "jpeg".equals(ext);
    }

    @Callable(rights={"Plugins_SkinFactory_EditCurrentSkin"}, context="/cms")
    public List<Object> getGalleryVariants(String skinName, String paramId) throws IOException {
        ArrayList<Object> galleryVariants = new ArrayList<Object>();
        String modelName = this._skinHelper.getTempModel(skinName);
        AbstractSkinParameter skinParameter = this._skinFactoryManager.getModelParamater(modelName, paramId);
        if (skinParameter instanceof VariantParameter) {
            VariantParameter variantParam = (VariantParameter)skinParameter;
            List<Variant> variants = variantParam.getVariants();
            for (Variant variant : variants) {
                HashMap<String, Object> jsonObject = new HashMap<String, Object>();
                jsonObject.put("value", variant.getId());
                String thumbnail = variant.getThumbnail();
                if (thumbnail != null) {
                    jsonObject.put("thumbnail", "/plugins/skinfactory/" + modelName + "/_thumbnail/32/32/model/variants/" + thumbnail);
                } else {
                    jsonObject.put("thumbnail", "/plugins/skinfactory/resources/img/variant_default_32.png");
                }
                jsonObject.put("label", variant.getLabel());
                jsonObject.put("description", variant.getDescription());
                galleryVariants.add(jsonObject);
            }
        }
        return galleryVariants;
    }

    @Callable(rights={"*"})
    public List<Object> getThemeColors(String siteName) {
        ArrayList<Object> themesJsonObject = new ArrayList<Object>();
        String skinId = this._siteManager.getSite(siteName).getSkinId();
        String modelName = this._skinHelper.getTempModel(skinId);
        SkinModel model = this._modelsManager.getModel(modelName);
        if (model != null) {
            Map themes = model.getThemes();
            for (String name : themes.keySet()) {
                HashMap<String, Object> jsonObject = new HashMap<String, Object>();
                SkinModel.Theme theme = (SkinModel.Theme)themes.get(name);
                jsonObject.put("id", theme.getId());
                jsonObject.put("label", theme.getLabel());
                jsonObject.put("colors", theme.getColors());
                themesJsonObject.add(jsonObject);
            }
        } else {
            this.getLogger().warn("Unable to get theme colors : the model '" + modelName + "' does not exist anymore");
        }
        return themesJsonObject;
    }
}

