<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2012 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:plugin="http://www.ametys.org/schema/plugin"
                exclude-result-prefixes="i18n plugin">
           
    <xsl:template match="CMS">
		<xsl:apply-templates select="model"/>
	</xsl:template>
	
	<xsl:template match="model">
		<model>
			<xsl:copy-of select="@*[local-name() != 'hash']"/>
			<xsl:attribute name="hash"><xsl:value-of select="/CMS/hash"/></xsl:attribute>

			<xsl:apply-templates/>
		</model>
	</xsl:template>
	
    <!-- For copying -->
	<xsl:template match="*">
		<xsl:copy>
			<xsl:copy-of select="@*"></xsl:copy-of>
		
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>

</xsl:stylesheet>