/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * Model menu button for the list of theme colors in the skin
 */
Ext.define('Ametys.plugins.skinfactory.ribbon.menu.ThemeColorsMenu', {
	extend: 'Ametys.ribbon.element.ui.ButtonController',
	
    /**
     * @property {Ext.menu.Menu} _menu The menu referencing the theme colors menu items.
     * @private
     */
	
	constructor: function(config)
	{
		this.callParent(arguments);
		Ametys.message.MessageBus.on(Ametys.message.Message.LOADED, this._onSkinLoaded, this);
	},
	
	createUI: function(size, colspan)
	{
		var element = this.callParent(arguments);
	
		var menu = element.getMenu();
		menu.items.each(function (menuItem) {
			menuItem.setHidden(true);
		});
		
		element.on("menushow", Ext.bind(this._onMenuShow, this));
		
		return element;
	},
	  
	/**
	 * @private
	 * Listener when the skin is loaded. Get the available languages of the current skin.
	 * @param {Ametys.message.Message} message The loaded message on bus
	 */
	_onSkinLoaded: function(message)
	{
		var target = message.getTarget(Ametys.message.MessageTarget.SKIN);
        if (target)
        {
        	Ametys.plugins.skincommons.helper.SkinHelper.getSkinModel(Ametys.plugins.skinfactory.skin.SkinDAO.SERVER_ROLE, null, target.getParameters().name, "temp", Ext.bind(this._getSkinModelCb, this));
        }
	},
	
	/**
	 * Callback after retrieving the model name for the skin.
	 * @param {String} skinName The skin name
	 * @param {String} modelName The model name
	 */
	_getSkinModelCb: function (skinName, modelName)
	{
		var currentColorTheme = Ametys.plugins.skinfactory.SkinParametersManager.getCurrentColorTheme();
		var hasColorTheme = false;
		
		this.getUIControls().each (function (elmt) {
			var menuPanel = elmt.getMenu().items.get(0);
			elmt.getMenu().items.each(function (menuItem) {
				var controller = Ametys.ribbon.RibbonManager.getUI(menuItem.controlId);
				var model = controller.getInitialConfig("modelName");
				menuItem.setHidden(modelName != model);
				hasColorTheme = hasColorTheme || (modelName == model);
			});
		});
		
		if (!hasColorTheme)
		{
			this.setAdditionalDescription(this.getInitialConfig("color-theme-description-empty"));
			this.disable();
		}
		else
		{
			this.setAdditionalDescription("");
			this.enable();
		}
	},
	
	/**
	 * Listener when the menu of the button is showed.
	 * @param {Ext.button.Button} button The button that owns the menu.
	 * @param {Ext.menu.Menu} menu The menu.
	 */
	_onMenuShow: function (button, menu)
	{
		var currentColorTheme = Ametys.plugins.skinfactory.SkinParametersManager.getCurrentColorTheme();
		
		menu.items.each(function (menuItem) {
			var controller = Ametys.ribbon.RibbonManager.getUI(menuItem.controlId);
			var theme = controller.getInitialConfig("theme");
			if (currentColorTheme == theme)
			{
				menuItem.setChecked(true, true);
			}
			else
			{
				menuItem.setChecked(false, true);
			}
		});
	}
	
});
