/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.skinfactory.model;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.core.ui.Callable;
import org.ametys.core.util.path.PathUtils;
import org.ametys.plugins.skincommons.SkinEditionHelper;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.runtime.util.AmetysHomeHelper;
import org.ametys.skinfactory.SkinFactoryComponent;
import org.ametys.skinfactory.filefilter.FileFilter;
import org.ametys.web.cocoon.I18nTransformer;
import org.ametys.web.cocoon.I18nUtils;
import org.ametys.web.skin.Skin;
import org.ametys.web.skin.SkinDAO;
import org.ametys.web.skin.SkinModel;
import org.ametys.web.skin.SkinModelsManager;
import org.ametys.web.skin.SkinsManager;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.commons.io.FileUtils;

public class SkinModelDAO
extends AbstractLogEnabled
implements Serviceable,
Component {
    private static final DateFormat _DATE_FORMAT = new SimpleDateFormat("yyyyMMdd-HHmm");
    private SkinsManager _skinsManager;
    private SkinModelsManager _modelsManager;
    private SkinFactoryComponent _skinFactoryManager;
    private SkinEditionHelper _skinHelper;
    private SkinDAO _skinDAO;
    private I18nUtils _i18nUtils;

    public void service(ServiceManager manager) throws ServiceException {
        this._skinsManager = (SkinsManager)manager.lookup(SkinsManager.ROLE);
        this._modelsManager = (SkinModelsManager)manager.lookup(SkinModelsManager.ROLE);
        this._skinFactoryManager = (SkinFactoryComponent)((Object)manager.lookup(SkinFactoryComponent.ROLE));
        this._skinHelper = (SkinEditionHelper)manager.lookup(SkinEditionHelper.ROLE);
        this._skinDAO = (SkinDAO)manager.lookup(SkinDAO.ROLE);
        this._i18nUtils = (I18nUtils)manager.lookup(org.ametys.core.util.I18nUtils.ROLE);
    }

    @Callable(rights={"Web_Rights_Admin_Skins"}, context="/admin")
    public Map<String, Object> getModel(String modelId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        SkinModel model = this._modelsManager.getModel(modelId);
        if (model != null) {
            result.put("name", model.getId());
            result.put("title", model.getLabel());
            result.put("isModifiable", model.isModifiable());
        }
        return result;
    }

    @Callable(rights={"Web_Rights_Admin_Skins"}, context="/admin")
    public Map<String, Object> getSkinsAndModels(boolean includeAbstract) {
        Map result = this._skinDAO.getSkins(includeAbstract);
        result.put("models", this._models2JsonObject());
        return result;
    }

    private List<Object> _models2JsonObject() {
        ArrayList<Object> modelsList = new ArrayList<Object>();
        Set models = this._modelsManager.getModels();
        for (String modelName : models) {
            HashMap<String, String> jsonModel = new HashMap<String, String>();
            SkinModel model = this._modelsManager.getModel(modelName);
            jsonModel.put("id", modelName);
            jsonModel.put("label", (String)model.getLabel());
            jsonModel.put("description", (String)model.getDescription());
            jsonModel.put("iconLarge", model.getLargeImage());
            jsonModel.put("iconSmall", model.getSmallImage());
            modelsList.add(jsonModel);
        }
        return modelsList;
    }

    @Callable(rights={"Web_Rights_Admin_Skins"}, context="/admin")
    public boolean modelExists(String modelId) throws ProcessingException {
        return this._modelsManager.getModels().contains(modelId);
    }

    @Callable(rights={"Web_Rights_Admin_Skins"}, context="/admin")
    public String importModel(String modelName, String tmpDirPath) throws IOException {
        Path tmpDir = AmetysHomeHelper.getAmetysHomeTmp().toPath().resolve(tmpDirPath);
        if (Files.isDirectory(tmpDir, new LinkOption[0])) {
            SkinModel model = this._modelsManager.getModel(modelName);
            if (model != null) {
                if (model.isModifiable()) {
                    PathUtils.deleteDirectory((Path)model.getPath());
                } else {
                    throw new IllegalStateException("The skin model '" + modelName + "' already exists and is not modifiable and thus cannot be replaced.");
                }
            }
            Path rootLocation = this._modelsManager.getLocalModelsLocation();
            PathUtils.moveDirectory((Path)tmpDir, (Path)rootLocation.resolve(modelName));
            this._i18nUtils.reloadCatalogues();
            I18nTransformer.needsReload();
        }
        return modelName;
    }

    @Callable(rights={"Web_Rights_Admin_Skins"}, context="/admin")
    public String generateSkin(String skinId, String modelId) throws IOException, ProcessingException {
        if (this._skinsManager.getSkins().contains(skinId)) {
            return "already-exists";
        }
        Path modelDir = this._modelsManager.getModel(modelId).getPath();
        Path skinDir = this._skinsManager.getLocalSkinsLocation().resolve(skinId);
        PathUtils.copyDirectory((Path)modelDir, (Path)skinDir, FileFilter.getModelFilter(modelDir), (boolean)false);
        try {
            Skin skin = this._skinsManager.getSkin(skinId);
            this._modelsManager.generateModelFile(skinDir, modelId);
            SkinModel model = this._modelsManager.getModel(modelId);
            String defaultColorTheme = model.getDefaultColorTheme();
            if (defaultColorTheme != null) {
                this._skinFactoryManager.saveColorTheme(skin.getRawPath(), defaultColorTheme);
            }
            this._skinFactoryManager.applyModelParameters(modelId, skin.getRawPath());
            I18nTransformer.needsReload();
            this._i18nUtils.reloadCatalogues();
        }
        catch (Exception e) {
            FileUtils.deleteDirectory((File)skinDir.toFile());
            throw new ProcessingException("The generation of skin failed", (Throwable)e);
        }
        return null;
    }

    @Callable(rights={"Web_Rights_Admin_Skins"}, context="/admin")
    public Map<String, Object> applyModelToAll(String modelId) throws IOException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("modifiedSkins", new ArrayList());
        result.put("unmodifiedSkins", new ArrayList());
        result.put("unmodifiableSkins", new ArrayList());
        Set skins = this._skinsManager.getSkins();
        for (String skinId : skins) {
            Skin skin = this._skinsManager.getSkin(skinId);
            if (!modelId.equals(this._modelsManager.getModelOfSkin(skin))) continue;
            if (!skin.isModifiable()) {
                List unmodifiableSkins = (List)result.get("unmodifiableSkins");
                unmodifiableSkins.add(this._getSkinProperty(skin));
                continue;
            }
            if (this.applyModel(skin, modelId)) {
                List modifiedSkins = (List)result.get("modifiedSkins");
                modifiedSkins.add(this._getSkinProperty(skin));
                continue;
            }
            List unmodifiedSkins = (List)result.get("unmodifiedSkins");
            unmodifiedSkins.add(this._getSkinProperty(skin));
        }
        return result;
    }

    private Map<String, Object> _getSkinProperty(Skin skin) {
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put("name", skin.getId());
        info.put("label", skin.getLabel());
        return info;
    }

    @Callable(rights={"Web_Rights_Admin_Skins"}, context="/admin")
    public boolean applyModel(String skinId, String modelId) throws IOException {
        Skin skin = this._skinsManager.getSkin(skinId);
        return this.applyModel(skin, modelId);
    }

    protected boolean applyModel(Skin skin, String modelId) throws IOException {
        if (!skin.isModifiable()) {
            throw new IllegalStateException("The skin '" + skin.getId() + "' is not modifiable and thus the model can not be applied.");
        }
        Path skinDir = skin.getRawPath();
        Path tmpDir = skinDir.getParent().resolve(skin.getId() + "." + _DATE_FORMAT.format(new Date()));
        Path modelDir = this._modelsManager.getModel(modelId).getPath();
        PathUtils.copyDirectory((Path)modelDir, (Path)tmpDir, FileFilter.getModelFilter(modelDir), (boolean)false);
        Path uploadDir = skinDir.resolve("model/_uploads");
        if (Files.exists(uploadDir, new LinkOption[0])) {
            Path tmpUploadDir = tmpDir.resolve("model/_uploads");
            Files.createDirectories(tmpUploadDir, new FileAttribute[0]);
            FileUtils.copyDirectory((File)uploadDir.toFile(), (File)tmpUploadDir.toFile());
        }
        Path xmlFile = skinDir.resolve("model.xml");
        FileUtils.copyFileToDirectory((File)xmlFile.toFile(), (File)tmpDir.toFile());
        Path tmpXmlFile = tmpDir.resolve("model.xml");
        this._skinFactoryManager.applyModelParameters(modelId, tmpDir);
        this._skinFactoryManager.updateHash(tmpXmlFile, this._modelsManager.getModelHash(modelId));
        if (!this._skinHelper.deleteQuicklyDirectory(skinDir)) {
            this.getLogger().error("Cannot delete skin directory {}", (Object)skinDir.toAbsolutePath().toString());
            return false;
        }
        FileUtils.moveDirectory((File)tmpDir.toFile(), (File)skinDir.toFile());
        return true;
    }

    @Callable(rights={"Web_Rights_Admin_Skins"}, context="/admin")
    public void delete(String modelId) throws IOException {
        SkinModel model = this._modelsManager.getModel(modelId);
        if (!model.isModifiable()) {
            throw new IllegalStateException("The skin model '" + modelId + "' is not modified and thus cannot be removed.");
        }
        Set skins = this._skinsManager.getSkins();
        for (String skinId : skins) {
            Skin skin = this._skinsManager.getSkin(skinId);
            if (!skin.isModifiable() || !modelId.equals(this._modelsManager.getModelOfSkin(skin))) continue;
            this._unlinkModel(skin);
        }
        Path file = model.getPath();
        if (Files.exists(file, new LinkOption[0])) {
            PathUtils.deleteDirectory((Path)file);
        }
    }

    @Callable(rights={"Web_Rights_Admin_Skins"}, context="/admin")
    public String unlinkModel(String skinId, String modelId) throws IOException {
        Skin skin = this._skinsManager.getSkin(skinId);
        if (!modelId.equals(this._modelsManager.getModelOfSkin(skin))) {
            return "incorrect-model";
        }
        this._unlinkModel(skin);
        return null;
    }

    private void _unlinkModel(Skin skin) throws IOException {
        if (!skin.isModifiable()) {
            throw new IllegalStateException("The skin '" + skin.getId() + "' is not modifiable and thus it can not be unlink to its model.");
        }
        Path skinDir = skin.getRawPath();
        Path modelFile = skinDir.resolve("model.xml");
        Path bakFile = skinDir.resolve("model.xml.bak");
        Files.deleteIfExists(bakFile);
        if (Files.exists(modelFile, new LinkOption[0])) {
            Files.move(modelFile, bakFile, new CopyOption[0]);
        }
    }
}

