<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2012 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:plugin="http://www.ametys.org/schema/plugin"
                exclude-result-prefixes="i18n plugin">
           
    <xsl:template match="CMS">
		<xsl:apply-templates select="model"/>
	</xsl:template>
	
	<xsl:template match="parameters">
		<parameters>
			<xsl:apply-templates select="parameter"/>
			
			<!-- New parameters -->
			<xsl:for-each select="/CMS/settings/param[not(@id = /CMS/model/parameters/parameter/@id)]">
				<xsl:choose>
					<xsl:when test="*">
						<parameter id="{@id}">
							<xsl:for-each select="*">
								<xsl:element name="{local-name()}"><xsl:value-of select="."/></xsl:element>
							</xsl:for-each>
						</parameter>
					</xsl:when>
					<xsl:otherwise>
						<parameter id="{@id}">
							<xsl:copy-of select="@*[local-name() != 'id']"/>
							<xsl:value-of select="."/>
						</parameter>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:for-each>
		</parameters>
	</xsl:template>
	
	<xsl:template match="parameter"> 
		<xsl:variable name="id" select="@id"/>
		
		<xsl:choose>
			<xsl:when test="/CMS/settings/param[@id = $id]/*">
				<parameter id="{$id}">
					<xsl:text/><xsl:for-each select="/CMS/settings/param[@id = $id]/*"><xsl:element name="{local-name()}"><xsl:value-of select="."/></xsl:element></xsl:for-each>
					<xsl:for-each select="*">
						<xsl:variable name="localname" select="local-name()"/>
						<xsl:if test="not(/CMS/settings/param[@id = $id]/*[local-name() = $localname])">
							<xsl:copy><xsl:copy-of select="@*"/><xsl:apply-templates/></xsl:copy>
						</xsl:if>
					</xsl:for-each>
				</parameter>
			</xsl:when>
			<xsl:when test="/CMS/settings/param[@id = $id]">
				<parameter id="{$id}">
					<xsl:copy-of select="/CMS/settings/param[@id = $id]/@*[local-name() != 'id']"></xsl:copy-of>
					<xsl:value-of select="/CMS/settings/param[@id = $id]"/>
				</parameter>
			</xsl:when>
			<xsl:otherwise>
				 <xsl:copy>
					<xsl:copy-of select="@*"></xsl:copy-of>
					<xsl:apply-templates/>
				</xsl:copy>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	     
    <!-- For copying -->
	<xsl:template match="*">
		<xsl:copy>
			<xsl:copy-of select="@*"></xsl:copy-of>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>

</xsl:stylesheet>