/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * Language menu button for the list of languages in the skin
 */
Ext.define('Ametys.plugins.skinfactory.ribbon.menu.LanguageMenu', {
	extend: 'Ametys.ribbon.element.ui.ButtonController',
	
	constructor: function(config)
	{
		this.callParent(arguments);
		
		this._languages = null;
		
		Ametys.message.MessageBus.on(Ametys.message.Message.LOADED, this._getLanguages, this);
	},
	
	createUI: function(size, colspan)
	{
		var element = this.callParent(arguments);

        this._getGalleries(element).each(function (menuSubPanel) {
			menuSubPanel.items.each(function (item) {
				item.setHidden(true);
				item.setTooltip();
			});
        });
		
		element.on("menushow", this._onMenuShow, this);
		
		return element;
	},
	
	/**
	 * @private
	 * Listener when the skin is loaded. Get the available languages of the current skin.
	 * @param {Ametys.message.Message} message The loaded message on bus
	 */
	_getLanguages: function(message)
	{
		var target = message.getTarget(Ametys.message.MessageTarget.SKIN);
        if (target)
        {
        	Ametys.plugins.skinfactory.SkinParametersManager.getLanguages(Ext.bind(this._getLanguagesCb, this));
        }
	},
		
	/**
	 * Callback after receiving the list of languages for this skin.
	 * @param {Object} languages The list of languages
	 * @private
	 */
	_getLanguagesCb: function (languages)
	{
		this._languages = languages;
	},
	
	/**
	 * Listener for the "menushow" event. Select and show the languages of the skin
	 * @param {Ext.button.Button} button The button that launched the event.
	 * @param {Ext.menu.Menu} menu The menu that is displayed.
	 * @private
	 */
	_onMenuShow: function (button, menu)
	{
		if (this._languages)
		{
			var me = this;
			var currentLanguage = Ametys.plugins.skinfactory.SkinParametersManager.getCurrentLanguage();

            this._getGalleries(button).each(function (gallery) {
                gallery.items.each(function(item) {
    				var controller = Ametys.ribbon.RibbonManager.getUI(item.controlId);
    				var lang = controller.getInitialConfig("lang");
    				item.setHidden(me._languages[lang] == null);
    				item.setPressed(currentLanguage == lang);
                });
            });
		}
	}
});
