/*
 *  Copyright 2011 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.skinfactory.actions;

import java.io.File;
import java.io.IOException;

import org.apache.commons.io.FileUtils;

/**
 * Thread for asynchronous file deletion
 *
 */
public class AsynchronousFileDeletion implements Runnable
{
    File _file;
    
    /**
     * Constructor
     * @param file The file to delete
     */
    public AsynchronousFileDeletion (File file)
    {
        _file = file;
    }
    
    @Override
    public void run()
    {
        if (_file != null)
        {
            try
            {
                if (_file.isDirectory())
                {
                    FileUtils.deleteDirectory(_file);
                }
                else 
                {
                    _file.delete();
                }
            }
            catch (IOException e)
            {
                try
                {
                    FileUtils.forceDeleteOnExit(_file);
                }
                catch (IOException ioe)
                {
                    // Nothing
                }
            }
            
        }

    }

}
