/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.skinfactory.clientsidelement;

import java.util.Collections;
import java.util.List;
import java.util.Map;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.core.ui.StaticClientSideElement;
import org.ametys.web.skin.SkinsManager;

/**
 * Client side element to open the skin editor. It is available if at least one skin is modifiable
 *
 */
public class OpenSkinFactoryClientSideElement extends StaticClientSideElement
{
    private SkinsManager _skinManager;
    
    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);
        _skinManager = (SkinsManager) smanager.lookup(SkinsManager.ROLE);
    }
    
    @Override
    public List<Script> getScripts(boolean ignoreRights, Map<String, Object> contextParameters)
    {
        String currentSkinName = _skinManager.getSkinNameFromRequest();
        boolean isModifiable = _skinManager.getSkin(currentSkinName).isModifiable();
        
        if (!isModifiable)
        {
            return Collections.EMPTY_LIST;
        }
        else
        {
            return super.getScripts(ignoreRights, contextParameters);
        }
    }
}
