/*
 *  Copyright 2011 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.skinfactory.parameters;

import org.ametys.runtime.i18n.I18nizableText;

/**
 * Class representing a variant
 *
 */
public class Variant
{
    String _id;
    I18nizableText _label;
    I18nizableText _description;
    String _thumbnail;
    
    /**
     * Constructor
     * @param id the id
     * @param label the label
     * @param description the description
     * @param thumbnail the thumbnail image
     */
    public Variant (String id, I18nizableText label, I18nizableText description, String thumbnail)
    {
        _id = id;
        _label = label;
        _description = description;
        _thumbnail = thumbnail;
    }
    
    /**
     * Get the source path
     * @return the source path
     */
    public String getId ()
    {
        return _id;
    }
    
    /**
     * Get the description
     * @return the description
     */
    public I18nizableText getLabel ()
    {
        return _label;
    }
    
    /**
     * Get the description
     * @return the description
     */
    public I18nizableText getDescription ()
    {
        return _description;
    }
    
    /**
     * Get the icon path
     * @return the icon path
     */
    public String getThumbnail ()
    {
        return _thumbnail;
    }
}
