/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.skinfactory.clientsidelement;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.core.ui.ClientSideElement;
import org.ametys.core.ui.SimpleMenu;
import org.ametys.core.ui.StaticClientSideElement;
import org.ametys.core.util.I18nUtils;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.skinfactory.model.ModelDesignsManager;
import org.ametys.web.skin.SkinModelsManager;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;

public class DesignsMenu
extends SimpleMenu {
    private ModelDesignsManager _designsManager;
    private boolean _designsInitialized;
    private SkinModelsManager _modelsManager;
    private I18nUtils _i18nUtils;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._designsManager = (ModelDesignsManager)((Object)smanager.lookup(ModelDesignsManager.ROLE));
        this._modelsManager = (SkinModelsManager)smanager.lookup(SkinModelsManager.ROLE);
        this._i18nUtils = (I18nUtils)smanager.lookup(I18nUtils.ROLE);
    }

    public List<ClientSideElement.Script> getScripts(boolean ignoreRights, Map<String, Object> contextParameters) {
        Set models = this._modelsManager.getModels();
        if (models != null) {
            boolean hasDesigns = models.stream().map(this._designsManager::getDesigns).anyMatch(d -> !d.isEmpty());
            if (hasDesigns) {
                return super.getScripts(ignoreRights, contextParameters);
            }
        }
        return Collections.EMPTY_LIST;
    }

    protected void _getGalleryItems(Map<String, Object> parameters, Map<String, Object> contextualParameters) {
        try {
            this._lazyInitializeDesignsGallery();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to lookup client side element local components", e);
        }
        if (this._galleryItems.size() > 0) {
            parameters.put("gallery-item", new LinkedHashMap());
            for (SimpleMenu.GalleryItem galleryItem : this._galleryItems) {
                Map galleryItems = (Map)parameters.get("gallery-item");
                galleryItems.put("gallery-groups", new ArrayList());
                for (SimpleMenu.GalleryGroup galleryGp : galleryItem.getGroups()) {
                    List galleryGroups = (List)galleryItems.get("gallery-groups");
                    LinkedHashMap<String, Object> groupParams = new LinkedHashMap<String, Object>();
                    I18nizableText label = galleryGp.getLabel();
                    groupParams.put("label", label);
                    ArrayList<String> gpItems = new ArrayList<String>();
                    for (ClientSideElement element : galleryGp.getItems()) {
                        gpItems.add(element.getId());
                    }
                    if (gpItems.size() <= 0) continue;
                    groupParams.put("items", gpItems);
                    galleryGroups.add(groupParams);
                }
            }
        }
    }

    private synchronized void _lazyInitializeDesignsGallery() throws ConfigurationException, ProcessingException {
        if (!this._designsInitialized) {
            Set models = this._modelsManager.getModels();
            SimpleMenu.GalleryItem galleryItem = new SimpleMenu.GalleryItem((SimpleMenu)this);
            SimpleMenu.GalleryGroup galleryGroup = new SimpleMenu.GalleryGroup((SimpleMenu)this, new I18nizableText("plugin." + this._pluginName, "PLUGINS_SKINFACTORY_DESIGNMENU_GROUP_LABEL"));
            galleryItem.addGroup(galleryGroup);
            for (String modelName : models) {
                Set<ModelDesignsManager.Design> designs = this._designsManager.getDesigns(modelName);
                if (designs.size() <= 0) continue;
                for (ModelDesignsManager.Design design : designs) {
                    String itemId = this.getId() + "-" + modelName + "-" + design.getId();
                    Configuration conf = this._getDesignConfiguration(itemId, design, modelName);
                    this._getGalleryItemManager().addComponent(this._pluginName, null, itemId, StaticClientSideElement.class, conf);
                    galleryGroup.addItem(new SimpleMenu.UnresolvedItem((SimpleMenu)this, itemId, true));
                }
            }
            this._galleryItems.add(galleryItem);
            try {
                this._getGalleryItemManager().initialize();
            }
            catch (Exception e) {
                throw new ConfigurationException("Unable to lookup parameter local components", (Throwable)e);
            }
            this._designsInitialized = true;
        }
    }

    protected Configuration _getDesignConfiguration(String id, ModelDesignsManager.Design design, String modelName) {
        DefaultConfiguration conf = new DefaultConfiguration("extension");
        conf.setAttribute("id", id);
        DefaultConfiguration classConf = new DefaultConfiguration("class");
        classConf.setAttribute("name", "Ametys.ribbon.element.ui.ButtonController");
        DefaultConfiguration labelConf = new DefaultConfiguration("label");
        labelConf.setValue(this._i18nUtils.translate((I18nizable)design.getLabel()));
        classConf.addChild((Configuration)labelConf);
        DefaultConfiguration descriptionConf = new DefaultConfiguration("description");
        descriptionConf.setValue(this._i18nUtils.translate((I18nizable)design.getDescription()));
        classConf.addChild((Configuration)descriptionConf);
        DefaultConfiguration iconSmallConf = new DefaultConfiguration("icon-small");
        iconSmallConf.setValue(design.getIcon());
        classConf.addChild((Configuration)iconSmallConf);
        DefaultConfiguration iconMediumConf = new DefaultConfiguration("icon-medium");
        iconMediumConf.setValue(design.getIcon());
        classConf.addChild((Configuration)iconMediumConf);
        DefaultConfiguration iconLargeConf = new DefaultConfiguration("icon-large");
        iconLargeConf.setValue(design.getIcon());
        classConf.addChild((Configuration)iconLargeConf);
        DefaultConfiguration modelNameConf = new DefaultConfiguration("modelName");
        modelNameConf.setValue(modelName);
        classConf.addChild((Configuration)modelNameConf);
        DefaultConfiguration designConf = new DefaultConfiguration("designId");
        designConf.setValue(design.getId());
        classConf.addChild((Configuration)designConf);
        Map commonConfig = (Map)this._script.getParameters().get("items-config");
        for (String tagName : commonConfig.keySet()) {
            DefaultConfiguration c = new DefaultConfiguration(tagName);
            c.setValue(String.valueOf(commonConfig.get(tagName)));
            classConf.addChild((Configuration)c);
        }
        conf.addChild((Configuration)classConf);
        return conf;
    }
}

