/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.skinfactory.parameters;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.skinfactory.parameters.AbstractSkinParameter;
import org.ametys.skinfactory.parameters.SkinParameterException;
import org.ametys.web.skin.SkinModel;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.io.IOUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class CSSParameter
extends AbstractSkinParameter {
    private final List<Path> _cssFiles;
    private final String _cssProperty;
    private final String _defaultValue;

    public CSSParameter(String id, I18nizableText label, I18nizableText description, Path cssFile, String cssProperty, String defaultValue) {
        super(id, label, description);
        this._cssFiles = new ArrayList<Path>();
        this._cssFiles.add(cssFile);
        this._cssProperty = cssProperty;
        this._defaultValue = defaultValue;
    }

    public CSSParameter(String id, I18nizableText label, I18nizableText description, List<Path> cssFiles, String cssProperty, String defaultValue) {
        super(id, label, description);
        this._cssFiles = cssFiles;
        this._cssProperty = cssProperty;
        this._defaultValue = defaultValue;
    }

    @Override
    public AbstractSkinParameter.SkinParameterType getType() {
        return AbstractSkinParameter.SkinParameterType.CSS;
    }

    public List<Path> getCSSFiles() {
        return this._cssFiles;
    }

    public void addCSSFile(Path cssFile) {
        for (Path f : this._cssFiles) {
            if (!f.normalize().toString().equals(cssFile.normalize().toString())) continue;
            return;
        }
        this._cssFiles.add(cssFile);
    }

    public String getCSSProperty() {
        return this._cssProperty;
    }

    @Override
    public void apply(Path tempDir, Path modelDir, Object value, String lang) throws SkinParameterException {
        for (Path file : this._cssFiles) {
            String relPath = modelDir.relativize(file).toString();
            Path cssFile = tempDir.resolve(relPath);
            String string = this.cssFileToString(cssFile);
            Pattern pattern = this.getCSSPattern();
            Matcher matcher = pattern.matcher(string);
            StringBuffer sb = new StringBuffer();
            int startIndex = 0;
            while (matcher.find()) {
                int propertyStart = matcher.start(2);
                String beforeValue = string.substring(startIndex, propertyStart);
                String oldValue = string.substring(propertyStart, matcher.end(2));
                sb.append(beforeValue);
                sb.append((String)value + (oldValue.endsWith(" ") ? " " : ""));
                sb.append(string.substring(matcher.end(2), matcher.end(3)));
                startIndex = matcher.end(3);
            }
            sb.append(string.substring(startIndex));
            try {
                OutputStream os = Files.newOutputStream(cssFile, new OpenOption[0]);
                try {
                    IOUtils.write((String)sb.toString(), (OutputStream)os, (Charset)StandardCharsets.UTF_8);
                }
                finally {
                    if (os == null) continue;
                    os.close();
                }
            }
            catch (IOException e) {
                throw new SkinParameterException("Unable to apply css parameter '" + this.getId() + "'", e);
            }
        }
    }

    protected Pattern getCSSPattern() {
        return Pattern.compile("\\s*([^,:\\s]*)\\s*:\\s*([^:;!]*)\\s*(?:!important)?\\s*\\/\\*\\s*AMETYS\\s*\\(\\s*\"(" + this.getId() + ")\"\\s*(?:,\\s*([^,\"\\s]+|\"[^\"]*\")\\s*)?(?:,\\s*([^,\"\\s]+|\"[^\"]*\")\\s*)?\\)\\s*\\*\\/\\s*;\\s*?", 8);
    }

    protected String cssFileToString(Path cssFile) throws SkinParameterException {
        String string;
        block8: {
            InputStream is = Files.newInputStream(cssFile, new OpenOption[0]);
            try {
                string = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new SkinParameterException("Unable to parse file '" + cssFile.getFileName().toString() + "'", e);
                }
            }
            is.close();
        }
        return string;
    }

    @Override
    public void toSAX(ContentHandler contentHandler, String modelName) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("id", this.getId());
        attrs.addCDATAAttribute("type", AbstractSkinParameter.SkinParameterType.CSS.name().toLowerCase());
        XMLUtils.startElement((ContentHandler)contentHandler, (String)"parameter", (Attributes)attrs);
        this.getLabel().toSAX(contentHandler, "label");
        this.getDescription().toSAX(contentHandler, "description");
        XMLUtils.createElement((ContentHandler)contentHandler, (String)"property", (String)this.getCSSProperty());
        XMLUtils.endElement((ContentHandler)contentHandler, (String)"parameter");
    }

    @Override
    public Map<String, Object> toJson(String modelName) {
        HashMap<String, Object> jsonObject = new HashMap<String, Object>();
        jsonObject.put("id", this.getId());
        jsonObject.put("type", AbstractSkinParameter.SkinParameterType.CSS.name().toLowerCase());
        jsonObject.put("label", this.getLabel());
        jsonObject.put("description", this.getDescription());
        jsonObject.put("property", this.getCSSProperty());
        return jsonObject;
    }

    @Override
    public String getDefaultValue(SkinModel model) {
        return this._defaultValue;
    }

    @Override
    public String getDefaultValue(SkinModel model, String lang) {
        return this.getDefaultValue(model);
    }
}

