/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.skinfactory.readers;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Map;
import javax.imageio.ImageIO;
import net.coobird.thumbnailator.makers.FixedSizeThumbnailMaker;
import net.coobird.thumbnailator.resizers.DefaultResizerFactory;
import org.ametys.core.util.ImageHelper;
import org.ametys.core.util.URIUtils;
import org.ametys.core.util.path.PathSource;
import org.ametys.plugins.skincommons.SkinEditionHelper;
import org.ametys.web.skin.SkinModel;
import org.ametys.web.skin.SkinModelsManager;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.reading.ServiceableReader;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.SourceValidity;
import org.xml.sax.SAXException;

public class SkinResourceReader
extends ServiceableReader
implements CacheableProcessingComponent {
    private SkinModelsManager _modelsManager;
    private SkinEditionHelper _skinHelper;
    private PathSource _source;
    private int _width;
    private int _height;
    private int _maxWidth;
    private int _maxHeight;

    public void service(ServiceManager sManager) throws ServiceException {
        super.service(sManager);
        this._modelsManager = (SkinModelsManager)sManager.lookup(SkinModelsManager.ROLE);
        this._skinHelper = (SkinEditionHelper)sManager.lookup(SkinEditionHelper.ROLE);
    }

    public void setup(SourceResolver sResolver, Map objModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(sResolver, objModel, src, par);
        this._width = par.getParameterAsInteger("width", 0);
        this._height = par.getParameterAsInteger("height", 0);
        this._maxWidth = par.getParameterAsInteger("maxWidth", 0);
        this._maxHeight = par.getParameterAsInteger("maxHeight", 0);
        String path = par.getParameter("path", null);
        assert (path != null);
        Path rootDir = null;
        String modelName = par.getParameter("modelName", null);
        if (StringUtils.isNotEmpty((CharSequence)modelName)) {
            SkinModel model = this._modelsManager.getModel(modelName);
            rootDir = model.getPath();
            this._source = new PathSource("model", "model:" + modelName + "://" + path, rootDir.resolve(URIUtils.decode((String)path)));
        } else {
            String skinName = par.getParameter("skinName", null);
            rootDir = this._skinHelper.getTempDirectory(skinName);
            this._source = new PathSource("file", rootDir.resolve(URIUtils.decode((String)path)));
        }
    }

    public Serializable getKey() {
        return this._source.getFile().toAbsolutePath().toString() + "#" + this._height + "#" + this._width + "#" + this._maxHeight + "#" + this._maxWidth;
    }

    public SourceValidity getValidity() {
        return this._source.getValidity();
    }

    public long getLastModified() {
        return this._source.getLastModified();
    }

    public String getMimeType() {
        return this._source.getMimeType();
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        String name = this._source.getName();
        name = name.replaceAll("\\\\", "\\\\\\\\");
        name = name.replaceAll("\\\"", "\\\\\\\"");
        Response response = ObjectModelHelper.getResponse((Map)this.objectModel);
        try (InputStream is = this._source.getInputStream();){
            if (this._width > 0 || this._height > 0) {
                int i = name.lastIndexOf(46);
                String format = name.substring(i + 1);
                ImageHelper.generateThumbnail((InputStream)is, (OutputStream)this.out, (String)format, (int)this._height, (int)this._width, (int)0, (int)0);
            } else if (this._maxHeight > 0 || this._maxWidth > 0) {
                int i = name.lastIndexOf(46);
                String format = name.substring(i + 1);
                byte[] fileContent = IOUtils.toByteArray((InputStream)is);
                BufferedImage src = ImageHelper.read((InputStream)new ByteArrayInputStream(fileContent));
                this._generateThumbnail(this.out, format, src, fileContent, this._maxHeight, this._maxWidth);
            } else {
                response.setHeader("Content-Length", Long.toString(this._source.getContentLength()));
                IOUtils.copy((InputStream)is, (OutputStream)this.out);
            }
            this.out.flush();
        }
        catch (Exception e) {
            throw new ProcessingException("Unable to download file of uri " + this._source.getURI(), (Throwable)e);
        }
    }

    public void recycle() {
        super.recycle();
        this._source = null;
    }

    private void _generateThumbnail(OutputStream os, String format, BufferedImage src, byte[] fileContent, int maxHeight, int maxWidth) throws IOException {
        int srcHeight = src.getHeight();
        int srcWidth = src.getWidth();
        if (maxWidth == srcWidth && maxHeight == srcHeight) {
            IOUtils.write((byte[])fileContent, (OutputStream)os);
            return;
        }
        if (srcWidth < maxWidth && srcHeight < maxHeight) {
            this._generateZoomAndCropImage(this.out, format, src, fileContent, maxHeight, maxWidth);
        } else {
            BufferedImage dest = ImageHelper.generateThumbnail((BufferedImage)src, (int)this._height, (int)this._width, (int)this._maxHeight, (int)this._maxWidth);
            if (src == dest) {
                IOUtils.write((byte[])fileContent, (OutputStream)os);
            } else {
                ImageIO.write((RenderedImage)dest, format, os);
            }
        }
    }

    private void _generateZoomAndCropImage(OutputStream os, String format, BufferedImage src, byte[] fileContent, int minHeight, int minWidth) throws IOException {
        int srcHeight = src.getHeight();
        int srcWidth = src.getWidth();
        int destHeight = 0;
        int destWidth = 0;
        Dimension srcDimension = new Dimension(srcWidth, srcHeight);
        boolean keepAspectRatio = true;
        if (srcWidth > srcHeight) {
            destHeight = minHeight;
            destWidth = srcWidth * destHeight / srcHeight;
        } else {
            destWidth = minWidth;
            destHeight = srcHeight * destWidth / srcWidth;
        }
        Dimension thumbnailDimension = new Dimension(destWidth, destHeight);
        BufferedImage thumbImage = new FixedSizeThumbnailMaker(destWidth, destHeight, keepAspectRatio, true).resizer(DefaultResizerFactory.getInstance().getResizer(srcDimension, thumbnailDimension)).imageType(src.getColorModel().hasAlpha() ? 2 : 1).make(src);
        BufferedImage cropImage = this._getCropImage(thumbImage, 0, 0, minHeight, minHeight);
        if (src == cropImage) {
            IOUtils.write((byte[])fileContent, (OutputStream)os);
        } else {
            ImageIO.write((RenderedImage)cropImage, format, os);
        }
    }

    private BufferedImage _getCropImage(BufferedImage src, int x, int y, int width, int height) {
        int srcHeight = src.getHeight();
        int srcWidth = src.getWidth();
        int w = width;
        if (width + x > srcWidth) {
            w = srcWidth - x;
        }
        int h = height;
        if (height + y > srcHeight) {
            h = srcHeight - y;
        }
        return src.getSubimage(x, y, w, h);
    }
}

