<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2012 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:plugin="http://www.ametys.org/schema/plugin"
                exclude-result-prefixes="plugin">
                
	<xsl:template match="CMS">
		<ribbon xmlns:i18n="http://apache.org/cocoon/i18n/2.1">
			<xsl:for-each select="parameters/tab">
				<xsl:sort select="@label"/>
				<tab label="{@label}" i18n:attr="" controlId="{@id}" contextualGroup="K" contextualColor="3" contextualLabel="plugin.skinfactory:RIBBON_TABS_TAB_SKINFACTORY_GROUP_LABEL">
					<groups>
						<xsl:for-each select="groups/group">
							<group id="{concat(../../@label, '.', @label)}" label="{@label}" i18n:attr="" icon="">
								<xsl:call-template name="layout-large"/>
								<xsl:call-template name="layout-medium"/>
								<xsl:call-template name="layout-small"/>
							</group>
						</xsl:for-each>
					</groups>
				</tab>
			</xsl:for-each>
        </ribbon>
	</xsl:template>                

	<xsl:template name="layout-large">
		<large>
			<!-- <xsl:apply-templates select="parameter|menu"/> -->
		</large>
	</xsl:template>
	
	<xsl:template name="layout-medium">
		<medium>
			<layout size="small" cols="{ceiling(count(parameter|menu) div 3)}">
				<xsl:apply-templates select="parameter|menu">
					<xsl:sort select="@id"/>
				</xsl:apply-templates>
			</layout>
		</medium>
	</xsl:template>
	
	<xsl:template name="layout-small">
		<small>
			<!-- <layout size="very-small" cols="{ceiling(count(parameter|menu) div 3)}">
				<xsl:apply-templates select="parameter|menu">
					<xsl:sort select="@id"/>
				</xsl:apply-templates>
			</layout> -->
		</small>
	</xsl:template>
	
	<xsl:template match="menu">
		<menu label="{@label}" i18n:attr="" controlId="{@id}">
			<xsl:if test="@iconGlyph">
				<xsl:attribute name="icon-glyph"><xsl:value-of select="@iconGlyph"/></xsl:attribute>
			</xsl:if>
			<xsl:if test="@iconSmall">
				<xsl:attribute name="icon-small"><xsl:value-of select="@iconSmall"/></xsl:attribute>
				<xsl:attribute name="icon-medium"><xsl:value-of select="@iconLarge"/></xsl:attribute>
			</xsl:if>
			<xsl:apply-templates select="parameter|menu">
				<xsl:sort select="@id"/>
			</xsl:apply-templates>
		</menu>
	</xsl:template>
	
	<xsl:template match="parameter">
		<parameter id="{@id}"/>
	</xsl:template>

	<xsl:template match="*">
		<xsl:copy>
			<xsl:copy-of select="@*"></xsl:copy-of>
		
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>

</xsl:stylesheet>